package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.OperationLog;
import com.xforceplus.jcwatsonsmatch.service.IOperationLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class OperationLogController {

  @Autowired
  private IOperationLogService operationLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param operationLog ${table.comment}
   * @return
   */
  @GetMapping("/operationlogs" )
  public XfR getOperationLogs(XfPage page, OperationLog operationLog) {
    return XfR.ok(operationLogServiceImpl.page(page, Wrappers.query(operationLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/operationlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(operationLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param operationLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/operationlogs")
  public XfR save(@RequestBody OperationLog operationLog) {
     return XfR.ok(operationLogServiceImpl.save(operationLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param operationLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/operationlogs/{id}")
  public XfR putUpdate(@RequestBody OperationLog operationLog,@PathVariable Long id) {
      operationLog.setId(id);
      return XfR.ok(operationLogServiceImpl.updateById(operationLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param operationLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/operationlogs/{id}")
  public XfR patchUpdate(@RequestBody OperationLog operationLog,@PathVariable Long id) {
      OperationLog upoperationLog = operationLogServiceImpl.getById(id);
      if(upoperationLog != null){
        upoperationLog = ObjectCopyUtils.copyProperties(operationLog,upoperationLog,true);
      }
      return XfR.ok(operationLogServiceImpl.updateById(upoperationLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/operationlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(operationLogServiceImpl.removeById(id));
  }

  @PostMapping("/operationlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "operation_log");
     params.put("request", condition);

     return XfR.ok(operationLogServiceImpl.querys(params));
  }

}
