package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.SystemWorkflowInstance;
import com.xforceplus.jcwatsonsmatch.service.ISystemWorkflowInstanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流流程实例对象前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class SystemWorkflowInstanceController {

  @Autowired
  private ISystemWorkflowInstanceService systemWorkflowInstanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowInstance 系统工作流流程实例对象
   * @return
   */
  @GetMapping("/systemworkflowinstances" )
  public XfR getSystemWorkflowInstances(XfPage page, SystemWorkflowInstance systemWorkflowInstance) {
    return XfR.ok(systemWorkflowInstanceServiceImpl.page(page, Wrappers.query(systemWorkflowInstance)));
  }

  /**
   * 通过id查询系统工作流流程实例对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowinstances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流流程实例对象
   * @param systemWorkflowInstance 系统工作流流程实例对象
   * @return XfR
   */
  @PostMapping("/systemworkflowinstances")
  public XfR save(@RequestBody SystemWorkflowInstance systemWorkflowInstance) {
     return XfR.ok(systemWorkflowInstanceServiceImpl.save(systemWorkflowInstance));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流流程实例对象
   * @param systemWorkflowInstance 系统工作流流程实例对象
   * @return XfR
   */
  @PutMapping("/systemworkflowinstances/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowInstance systemWorkflowInstance,@PathVariable Long id) {
      systemWorkflowInstance.setId(id);
      return XfR.ok(systemWorkflowInstanceServiceImpl.updateById(systemWorkflowInstance));
  }

  /**
   * 修改-传入修改的数据系统工作流流程实例对象
   * @param systemWorkflowInstance 系统工作流流程实例对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowinstances/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowInstance systemWorkflowInstance,@PathVariable Long id) {
      SystemWorkflowInstance upsystemWorkflowInstance = systemWorkflowInstanceServiceImpl.getById(id);
      if(upsystemWorkflowInstance != null){
        upsystemWorkflowInstance = ObjectCopyUtils.copyProperties(systemWorkflowInstance,upsystemWorkflowInstance,true);
      }
      return XfR.ok(systemWorkflowInstanceServiceImpl.updateById(upsystemWorkflowInstance));
  }

  /**
   * 通过id删除系统工作流流程实例对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowinstances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowinstances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_instance");
     params.put("request", condition);

     return XfR.ok(systemWorkflowInstanceServiceImpl.querys(params));
  }

}
