package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.BizStore;
import com.xforceplus.jcwatsonsmatch.service.IBizStoreService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-29
 */
@RestController
public class BizStoreController {

  @Autowired
  private IBizStoreService bizStoreServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizStore ${table.comment}
   * @return
   */
  @GetMapping("/bizstores" )
  public XfR getBizStores(XfPage page, BizStore bizStore) {
    return XfR.ok(bizStoreServiceImpl.page(page, Wrappers.query(bizStore)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizstores/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizStoreServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizStore ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizstores")
  public XfR save(@RequestBody BizStore bizStore) {
     return XfR.ok(bizStoreServiceImpl.save(bizStore));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizStore ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizstores/{id}")
  public XfR putUpdate(@RequestBody BizStore bizStore,@PathVariable Long id) {
      bizStore.setId(id);
      return XfR.ok(bizStoreServiceImpl.updateById(bizStore));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizStore ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizstores/{id}")
  public XfR patchUpdate(@RequestBody BizStore bizStore,@PathVariable Long id) {
      BizStore upbizStore = bizStoreServiceImpl.getById(id);
      if(upbizStore != null){
        upbizStore = ObjectCopyUtils.copyProperties(bizStore,upbizStore,true);
      }
      return XfR.ok(bizStoreServiceImpl.updateById(upbizStore));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizstores/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizStoreServiceImpl.removeById(id));
  }

  @PostMapping("/bizstores/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_store");
     params.put("request", condition);

     return XfR.ok(bizStoreServiceImpl.querys(params));
  }

}
