package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.DataAuth;
import com.xforceplus.jcwatsonsmatch.service.IDataAuthService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-29
 */
@RestController
public class DataAuthController {

  @Autowired
  private IDataAuthService dataAuthServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dataAuth ${table.comment}
   * @return
   */
  @GetMapping("/dataauths" )
  public XfR getDataAuths(XfPage page, DataAuth dataAuth) {
    return XfR.ok(dataAuthServiceImpl.page(page, Wrappers.query(dataAuth)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dataauths/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dataAuthServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dataAuth ${table.comment}
   * @return XfR
   */
  @PostMapping("/dataauths")
  public XfR save(@RequestBody DataAuth dataAuth) {
     return XfR.ok(dataAuthServiceImpl.save(dataAuth));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dataAuth ${table.comment}
   * @return XfR
   */
  @PutMapping("/dataauths/{id}")
  public XfR putUpdate(@RequestBody DataAuth dataAuth,@PathVariable Long id) {
      dataAuth.setId(id);
      return XfR.ok(dataAuthServiceImpl.updateById(dataAuth));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dataAuth ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dataauths/{id}")
  public XfR patchUpdate(@RequestBody DataAuth dataAuth,@PathVariable Long id) {
      DataAuth updataAuth = dataAuthServiceImpl.getById(id);
      if(updataAuth != null){
        updataAuth = ObjectCopyUtils.copyProperties(dataAuth,updataAuth,true);
      }
      return XfR.ok(dataAuthServiceImpl.updateById(updataAuth));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dataauths/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dataAuthServiceImpl.removeById(id));
  }

  @PostMapping("/dataauths/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "data_auth");
     params.put("request", condition);

     return XfR.ok(dataAuthServiceImpl.querys(params));
  }

}
