package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.PayLog;
import com.xforceplus.jcwatsonsmatch.service.IPayLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-29
 */
@RestController
public class PayLogController {

  @Autowired
  private IPayLogService payLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payLog ${table.comment}
   * @return
   */
  @GetMapping("/paylogs" )
  public XfR getPayLogs(XfPage page, PayLog payLog) {
    return XfR.ok(payLogServiceImpl.page(page, Wrappers.query(payLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paylogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param payLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/paylogs")
  public XfR save(@RequestBody PayLog payLog) {
     return XfR.ok(payLogServiceImpl.save(payLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param payLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/paylogs/{id}")
  public XfR putUpdate(@RequestBody PayLog payLog,@PathVariable Long id) {
      payLog.setId(id);
      return XfR.ok(payLogServiceImpl.updateById(payLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param payLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paylogs/{id}")
  public XfR patchUpdate(@RequestBody PayLog payLog,@PathVariable Long id) {
      PayLog uppayLog = payLogServiceImpl.getById(id);
      if(uppayLog != null){
        uppayLog = ObjectCopyUtils.copyProperties(payLog,uppayLog,true);
      }
      return XfR.ok(payLogServiceImpl.updateById(uppayLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paylogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payLogServiceImpl.removeById(id));
  }

  @PostMapping("/paylogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_log");
     params.put("request", condition);

     return XfR.ok(payLogServiceImpl.querys(params));
  }

}
