package com.xforceplus.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsonsmatch.entity.InvoiceDetailOrPayLog;
import com.xforceplus.jcwatsonsmatch.service.IInvoiceDetailOrPayLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-14
 */
@RestController
public class InvoiceDetailOrPayLogController {

  @Autowired
  private IInvoiceDetailOrPayLogService invoiceDetailOrPayLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDetailOrPayLog ${table.comment}
   * @return
   */
  @GetMapping("/invoicedetailorpaylogs" )
  public XfR getInvoiceDetailOrPayLogs(XfPage page, InvoiceDetailOrPayLog invoiceDetailOrPayLog) {
    return XfR.ok(invoiceDetailOrPayLogServiceImpl.page(page, Wrappers.query(invoiceDetailOrPayLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedetailorpaylogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailOrPayLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDetailOrPayLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedetailorpaylogs")
  public XfR save(@RequestBody InvoiceDetailOrPayLog invoiceDetailOrPayLog) {
     return XfR.ok(invoiceDetailOrPayLogServiceImpl.save(invoiceDetailOrPayLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDetailOrPayLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedetailorpaylogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceDetailOrPayLog invoiceDetailOrPayLog,@PathVariable Long id) {
      invoiceDetailOrPayLog.setId(id);
      return XfR.ok(invoiceDetailOrPayLogServiceImpl.updateById(invoiceDetailOrPayLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDetailOrPayLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedetailorpaylogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDetailOrPayLog invoiceDetailOrPayLog,@PathVariable Long id) {
      InvoiceDetailOrPayLog upinvoiceDetailOrPayLog = invoiceDetailOrPayLogServiceImpl.getById(id);
      if(upinvoiceDetailOrPayLog != null){
        upinvoiceDetailOrPayLog = ObjectCopyUtils.copyProperties(invoiceDetailOrPayLog,upinvoiceDetailOrPayLog,true);
      }
      return XfR.ok(invoiceDetailOrPayLogServiceImpl.updateById(upinvoiceDetailOrPayLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedetailorpaylogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailOrPayLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedetailorpaylogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_detail_or_pay_log");
     params.put("request", condition);

     return XfR.ok(invoiceDetailOrPayLogServiceImpl.querys(params));
  }

}
