package com.xforceplus.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcwatsons.entity.AffirmInvoice;
import com.xforceplus.jcwatsons.service.IAffirmInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-13
 */
@RestController
public class AffirmInvoiceController {

  @Autowired
  private IAffirmInvoiceService affirmInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param affirmInvoice ${table.comment}
   * @return
   */
  @GetMapping("/affirminvoices" )
  public XfR getAffirmInvoices(XfPage page, AffirmInvoice affirmInvoice) {
    return XfR.ok(affirmInvoiceServiceImpl.page(page, Wrappers.query(affirmInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/affirminvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(affirmInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param affirmInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/affirminvoices")
  public XfR save(@RequestBody AffirmInvoice affirmInvoice) {
     return XfR.ok(affirmInvoiceServiceImpl.save(affirmInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param affirmInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/affirminvoices/{id}")
  public XfR putUpdate(@RequestBody AffirmInvoice affirmInvoice,@PathVariable Long id) {
      affirmInvoice.setId(id);
      return XfR.ok(affirmInvoiceServiceImpl.updateById(affirmInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param affirmInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/affirminvoices/{id}")
  public XfR patchUpdate(@RequestBody AffirmInvoice affirmInvoice,@PathVariable Long id) {
      AffirmInvoice upaffirmInvoice = affirmInvoiceServiceImpl.getById(id);
      if(upaffirmInvoice != null){
        upaffirmInvoice = ObjectCopyUtils.copyProperties(affirmInvoice,upaffirmInvoice,true);
      }
      return XfR.ok(affirmInvoiceServiceImpl.updateById(upaffirmInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/affirminvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(affirmInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/affirminvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "affirm_invoice");
     params.put("request", condition);

     return XfR.ok(affirmInvoiceServiceImpl.querys(params));
  }

}
