package com.xforceplus.jcwilmarlocal.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 收货信息
 * </p>
 *
 * @author ultraman
 * @since 2023-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsReceipt implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 不合格审批单号
   */
  @TableField("unqualifiedNumber")
  private String unqualifiedNumber;

  /**
   * 物料凭证编号
   */
  @TableField("materialDocNo")
  private String materialDocNo;

  /**
   * 物料凭证年度
   */
  @TableField("materialDocYear")
  private String materialDocYear;

  /**
   * 物料凭证中的项目
   */
  @TableField("materialDocItem")
  private String materialDocItem;

  /**
   * 凭证中的过帐日期
   */
  @TableField("postingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;

  /**
   * 车船号
   */
  @TableField("vehicleVesselNo")
  private String vehicleVesselNo;

  /**
   * 凭证文本
   */
  @TableField("docText")
  private String docText;

  /**
   * 库位
   */
  @TableField("warehouseLocation")
  private String warehouseLocation;

  /**
   * 收货数量
   */
  @TableField("receivedQuantity")
  private BigDecimal receivedQuantity;

  /**
   * 收货单位
   */
  @TableField("receivedUnit")
  private String receivedUnit;

  /**
   * 生产日期
   */
  @TableField("manufactureDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime manufactureDate;

  /**
   * 退货数量
   */
  @TableField("returnQuantity")
  private BigDecimal returnQuantity;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 unqualified
   */
    private Long unqualifiedToGoodsReceiptManyId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("unqualifiedNumber", unqualifiedNumber);
      map.put("materialDocNo", materialDocNo);
      map.put("materialDocYear", materialDocYear);
      map.put("materialDocItem", materialDocItem);
      map.put("postingDate", BocpGenUtils.toTimestamp(postingDate));
      map.put("vehicleVesselNo", vehicleVesselNo);
      map.put("docText", docText);
      map.put("warehouseLocation", warehouseLocation);
      map.put("receivedQuantity", receivedQuantity);
      map.put("receivedUnit", receivedUnit);
      map.put("manufactureDate", BocpGenUtils.toTimestamp(manufactureDate));
      map.put("returnQuantity", returnQuantity);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("unqualifiedToGoodsReceiptMany.id", unqualifiedToGoodsReceiptManyId);
      return map;
  }

  public static GoodsReceipt fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsReceipt entity = new GoodsReceipt();
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualifiedNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDocNo")) {
      Object obj = map.get("materialDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDocYear")) {
      Object obj = map.get("materialDocYear");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialDocYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDocItem")) {
      Object obj = map.get("materialDocItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialDocItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("vehicleVesselNo")) {
      Object obj = map.get("vehicleVesselNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleVesselNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docText")) {
      Object obj = map.get("docText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseLocation")) {
      Object obj = map.get("warehouseLocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivedQuantity")) {
      Object obj = map.get("receivedQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivedUnit")) {
      Object obj = map.get("receivedUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivedUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufactureDate")) {
      Object obj = map.get("manufactureDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setManufactureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setManufactureDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setManufactureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setManufactureDate(null);
      }
    }
    if(map.containsKey("returnQuantity")) {
      Object obj = map.get("returnQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("unqualifiedToGoodsReceiptMany.id")) {
        Object obj = map.get("unqualifiedToGoodsReceiptMany.id");
      if(obj instanceof Long) {
        entity.setUnqualifiedToGoodsReceiptManyId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setUnqualifiedToGoodsReceiptManyId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualifiedNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialDocNo")) {
      Object obj = map.get("materialDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialDocYear")) {
      Object obj = map.get("materialDocYear");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialDocYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialDocItem")) {
      Object obj = map.get("materialDocItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialDocItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("postingDate")) {
      Object obj = map.get("postingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPostingDate(null);
      }
    }
    if(map.containsKey("vehicleVesselNo")) {
      Object obj = map.get("vehicleVesselNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleVesselNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("docText")) {
      Object obj = map.get("docText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseLocation")) {
      Object obj = map.get("warehouseLocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivedQuantity")) {
      Object obj = map.get("receivedQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceivedQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceivedQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceivedQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivedQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivedQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receivedUnit")) {
      Object obj = map.get("receivedUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivedUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manufactureDate")) {
      Object obj = map.get("manufactureDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setManufactureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setManufactureDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setManufactureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setManufactureDate(null);
      }
    }
    if(map.containsKey("returnQuantity")) {
      Object obj = map.get("returnQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReturnQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReturnQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReturnQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReturnQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("unqualifiedToGoodsReceiptMany.id")) {
        Object obj = map.get("unqualifiedToGoodsReceiptMany.id");
        if(obj instanceof Long) {
          this.setUnqualifiedToGoodsReceiptManyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnqualifiedToGoodsReceiptManyId(Long.parseLong((String)obj));
        }
      }
  }
}
