package com.xforceplus.jcwilmarlocal.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 初检信息
 * </p>
 *
 * @author ultraman
 * @since 2023-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class QualityInspectionFirst implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 不合格审批单号
   */
  @TableField("unqualifiedNumber")
  private String unqualifiedNumber;

  /**
   * 不合格评审单项目号
   */
  @TableField("unqualifiedItem")
  private String unqualifiedItem;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 不合格评审类型
   */
  @TableField("unqualifiedType")
  private String unqualifiedType;

  /**
   * 检验项目
   */
  @TableField("inspectionItems")
  private String inspectionItems;

  /**
   * 验收标准
   */
  @TableField("acceptanceCriteria")
  private String acceptanceCriteria;

  /**
   * 检验结果
   */
  @TableField("testResults")
  private String testResults;

  /**
   * 单项判定
   */
  @TableField("singleJudgment")
  private String singleJudgment;

  /**
   * 检验方法
   */
  @TableField("testMethod")
  private String testMethod;

  /**
   * 化验人
   */
  private String chemist;

  /**
   * 检验日期
   */
  @TableField("inspectionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime inspectionDate;


  /**
   * 对一关联关系 关联对象 unqualified
   */
    private Long unqualifiedToQualityInspectionFirstManyId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("unqualifiedNumber", unqualifiedNumber);
      map.put("unqualifiedItem", unqualifiedItem);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("unqualifiedType", unqualifiedType);
      map.put("inspectionItems", inspectionItems);
      map.put("acceptanceCriteria", acceptanceCriteria);
      map.put("testResults", testResults);
      map.put("singleJudgment", singleJudgment);
      map.put("testMethod", testMethod);
      map.put("chemist", chemist);
      map.put("inspectionDate", BocpGenUtils.toTimestamp(inspectionDate));

       map.put("unqualifiedToQualityInspectionFirstMany.id", unqualifiedToQualityInspectionFirstManyId);
      return map;
  }

  public static QualityInspectionFirst fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    QualityInspectionFirst entity = new QualityInspectionFirst();
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualifiedNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unqualifiedItem")) {
      Object obj = map.get("unqualifiedItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualifiedItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unqualifiedType")) {
      Object obj = map.get("unqualifiedType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualifiedType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspectionItems")) {
      Object obj = map.get("inspectionItems");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectionItems((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceCriteria")) {
      Object obj = map.get("acceptanceCriteria");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcceptanceCriteria((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testResults")) {
      Object obj = map.get("testResults");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTestResults((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("singleJudgment")) {
      Object obj = map.get("singleJudgment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSingleJudgment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testMethod")) {
      Object obj = map.get("testMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTestMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chemist")) {
      Object obj = map.get("chemist");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChemist((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspectionDate")) {
      Object obj = map.get("inspectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInspectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInspectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInspectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInspectionDate(null);
      }
    }

    if(map.containsKey("unqualifiedToQualityInspectionFirstMany.id")) {
        Object obj = map.get("unqualifiedToQualityInspectionFirstMany.id");
      if(obj instanceof Long) {
        entity.setUnqualifiedToQualityInspectionFirstManyId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setUnqualifiedToQualityInspectionFirstManyId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualifiedNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unqualifiedItem")) {
      Object obj = map.get("unqualifiedItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualifiedItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unqualifiedType")) {
      Object obj = map.get("unqualifiedType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualifiedType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspectionItems")) {
      Object obj = map.get("inspectionItems");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectionItems((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acceptanceCriteria")) {
      Object obj = map.get("acceptanceCriteria");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAcceptanceCriteria((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("testResults")) {
      Object obj = map.get("testResults");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTestResults((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("singleJudgment")) {
      Object obj = map.get("singleJudgment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSingleJudgment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("testMethod")) {
      Object obj = map.get("testMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTestMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chemist")) {
      Object obj = map.get("chemist");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChemist((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspectionDate")) {
      Object obj = map.get("inspectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInspectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInspectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInspectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInspectionDate(null);
      }
    }
      if(map.containsKey("unqualifiedToQualityInspectionFirstMany.id")) {
        Object obj = map.get("unqualifiedToQualityInspectionFirstMany.id");
        if(obj instanceof Long) {
          this.setUnqualifiedToQualityInspectionFirstManyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnqualifiedToQualityInspectionFirstManyId(Long.parseLong((String)obj));
        }
      }
  }
}
