package com.xforceplus.jcwilmarlocal.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 退货信息
 * </p>
 *
 * @author ultraman
 * @since 2023-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Returns implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 不合格审批单号
   */
  @TableField("unqualifiedNumber")
  private String unqualifiedNumber;

  /**
   * 采购凭证号
   */
  @TableField("purchaseOrder")
  private String purchaseOrder;

  /**
   * 行项目
   */
  @TableField("poItemNumber")
  private String poItemNumber;

  /**
   * 采购凭证类型
   */
  @TableField("purchaseDoctype")
  private String purchaseDoctype;

  /**
   * 创建人
   */
  @TableField("creatorDomain")
  private String creatorDomain;

  /**
   * 供货数量
   */
  @TableField("supplyQuantity")
  private BigDecimal supplyQuantity;

  /**
   * 退货数量
   */
  @TableField("returnQuantity")
  private BigDecimal returnQuantity;

  /**
   * 单位
   */
  private String unit;

  /**
   * 到货日期
   */
  @TableField("arrivalDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime arrivalDate;

  /**
   * 车船号
   */
  @TableField("vehicleVesselNo")
  private String vehicleVesselNo;

  /**
   * 生产日期
   */
  @TableField("manufactureDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime manufactureDate;

  /**
   * 生产批号
   */
  @TableField("batchNumber")
  private String batchNumber;

  /**
   * 保质期
   */
  @TableField("expirationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expirationDate;

  /**
   * 备注信息
   */
  private String remarks;

  /**
   * PO含税单价
   */
  @TableField("vatInclusive")
  private BigDecimal vatInclusive;

  /**
   * 货币
   */
  private String currency;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 unqualified
   */
    private Long unqualifiedToReturnsManyId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("unqualifiedNumber", unqualifiedNumber);
      map.put("purchaseOrder", purchaseOrder);
      map.put("poItemNumber", poItemNumber);
      map.put("purchaseDoctype", purchaseDoctype);
      map.put("creatorDomain", creatorDomain);
      map.put("supplyQuantity", supplyQuantity);
      map.put("returnQuantity", returnQuantity);
      map.put("unit", unit);
      map.put("arrivalDate", BocpGenUtils.toTimestamp(arrivalDate));
      map.put("vehicleVesselNo", vehicleVesselNo);
      map.put("manufactureDate", BocpGenUtils.toTimestamp(manufactureDate));
      map.put("batchNumber", batchNumber);
      map.put("expirationDate", BocpGenUtils.toTimestamp(expirationDate));
      map.put("remarks", remarks);
      map.put("vatInclusive", vatInclusive);
      map.put("currency", currency);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("unqualifiedToReturnsMany.id", unqualifiedToReturnsManyId);
      return map;
  }

  public static Returns fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Returns entity = new Returns();
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualifiedNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poItemNumber")) {
      Object obj = map.get("poItemNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoItemNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseDoctype")) {
      Object obj = map.get("purchaseDoctype");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseDoctype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creatorDomain")) {
      Object obj = map.get("creatorDomain");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatorDomain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplyQuantity")) {
      Object obj = map.get("supplyQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSupplyQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSupplyQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSupplyQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSupplyQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSupplyQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("returnQuantity")) {
      Object obj = map.get("returnQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrivalDate")) {
      Object obj = map.get("arrivalDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setArrivalDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setArrivalDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setArrivalDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setArrivalDate(null);
      }
    }
    if(map.containsKey("vehicleVesselNo")) {
      Object obj = map.get("vehicleVesselNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleVesselNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manufactureDate")) {
      Object obj = map.get("manufactureDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setManufactureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setManufactureDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setManufactureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setManufactureDate(null);
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expirationDate")) {
      Object obj = map.get("expirationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpirationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpirationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpirationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpirationDate(null);
      }
    }
    if(map.containsKey("remarks")) {
      Object obj = map.get("remarks");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarks((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatInclusive")) {
      Object obj = map.get("vatInclusive");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatInclusive((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatInclusive(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatInclusive(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatInclusive(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatInclusive(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("unqualifiedToReturnsMany.id")) {
        Object obj = map.get("unqualifiedToReturnsMany.id");
      if(obj instanceof Long) {
        entity.setUnqualifiedToReturnsManyId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setUnqualifiedToReturnsManyId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualifiedNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poItemNumber")) {
      Object obj = map.get("poItemNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoItemNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseDoctype")) {
      Object obj = map.get("purchaseDoctype");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseDoctype((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creatorDomain")) {
      Object obj = map.get("creatorDomain");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatorDomain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplyQuantity")) {
      Object obj = map.get("supplyQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSupplyQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSupplyQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSupplyQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSupplyQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSupplyQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("returnQuantity")) {
      Object obj = map.get("returnQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReturnQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReturnQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReturnQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReturnQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("arrivalDate")) {
      Object obj = map.get("arrivalDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setArrivalDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setArrivalDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setArrivalDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setArrivalDate(null);
      }
    }
    if(map.containsKey("vehicleVesselNo")) {
      Object obj = map.get("vehicleVesselNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleVesselNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manufactureDate")) {
      Object obj = map.get("manufactureDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setManufactureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setManufactureDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setManufactureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setManufactureDate(null);
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expirationDate")) {
      Object obj = map.get("expirationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpirationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpirationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpirationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpirationDate(null);
      }
    }
    if(map.containsKey("remarks")) {
      Object obj = map.get("remarks");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemarks((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatInclusive")) {
      Object obj = map.get("vatInclusive");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatInclusive((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatInclusive(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatInclusive(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatInclusive(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatInclusive(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("unqualifiedToReturnsMany.id")) {
        Object obj = map.get("unqualifiedToReturnsMany.id");
        if(obj instanceof Long) {
          this.setUnqualifiedToReturnsManyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnqualifiedToReturnsManyId(Long.parseLong((String)obj));
        }
      }
  }
}
