package com.xforceplus.jcwilmarlocal.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 不合格申请单
 * </p>
 *
 * @author ultraman
 * @since 2023-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Unqualified implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 公司代码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 不合格审批单号
   */
  @TableField("unqualifiedNumber")
  private String unqualifiedNumber;

  /**
   * NCP申请单号
   */
  @TableField("ncpApplyNumber")
  private String ncpApplyNumber;

  /**
   * FSSC申请单号
   */
  @TableField("epmOrder")
  private String epmOrder;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 状态
   */
  private String status;

  /**
   * 拒绝原因
   */
  @TableField("refuseReason")
  private String refuseReason;

  /**
   * 采购凭证号
   */
  @TableField("purchaseOrder")
  private String purchaseOrder;

  /**
   * 采购凭证的项目编号
   */
  @TableField("poItemNumber")
  private String poItemNumber;

  /**
   * 车船号
   */
  @TableField("vehicleNumber")
  private String vehicleNumber;

  /**
   * 供应商帐号
   */
  @TableField("supplierNumber")
  private String supplierNumber;

  /**
   * 供应商描述
   */
  @TableField("supplierDescription")
  private String supplierDescription;

  /**
   * 采购类别
   */
  @TableField("purchaseType")
  private String purchaseType;

  /**
   * 申请人
   */
  private String applicant;

  /**
   * 记录的创建日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 批号
   */
  @TableField("batchNumber")
  private String batchNumber;

  /**
   * 样品数量
   */
  @TableField("samplesNumber")
  private BigDecimal samplesNumber;

  /**
   * 样品数量单位
   */
  @TableField("samplesUnit")
  private String samplesUnit;

  /**
   * 样品来源
   */
  @TableField("samplesSource")
  private String samplesSource;

  /**
   * 取样人
   */
  private String samplers;

  /**
   * 保质期
   */
  @TableField("expirationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expirationDate;

  /**
   * 物料号
   */
  @TableField("materialNumber")
  private String materialNumber;

  /**
   * 物料描述
   */
  @TableField("materialDescribe")
  private String materialDescribe;

  /**
   * 送货单号
   */
  @TableField("deliveryNo")
  private String deliveryNo;

  /**
   * 总收货数量
   */
  @TableField("totalQuantity")
  private BigDecimal totalQuantity;

  /**
   * 单位
   */
  private String unit;

  /**
   * PO含税单价
   */
  @TableField("vatInclusive")
  private BigDecimal vatInclusive;

  /**
   * 货币
   */
  private String currency;

  /**
   * 不合格描述
   */
  @TableField("disqualificationReasons")
  private String disqualificationReasons;

  /**
   * PO创建人域账号
   */
  @TableField("creatorDomain")
  private String creatorDomain;

  /**
   * 采购凭证类型
   */
  @TableField("purchaseDoctype")
  private String purchaseDoctype;

  /**
   * 处理方式
   */
  @TableField("processTrack")
  private String processTrack;

  /**
   * 调整方式
   */
  @TableField("adjustMode")
  private String adjustMode;

  /**
   * 调整数量
   */
  @TableField("adjustQuantity")
  private BigDecimal adjustQuantity;

  /**
   * 调整单价
   */
  @TableField("adjustPrice")
  private BigDecimal adjustPrice;

  /**
   * 调整总金额
   */
  @TableField("adjustAmount")
  private BigDecimal adjustAmount;

  /**
   * 公司税号
   */
  @TableField("companyTaxNo")
  private String companyTaxNo;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 供应商税号
   */
  @TableField("supplierTaxNo")
  private String supplierTaxNo;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("companyCode", companyCode);
      map.put("unqualifiedNumber", unqualifiedNumber);
      map.put("ncpApplyNumber", ncpApplyNumber);
      map.put("epmOrder", epmOrder);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("status", status);
      map.put("refuseReason", refuseReason);
      map.put("purchaseOrder", purchaseOrder);
      map.put("poItemNumber", poItemNumber);
      map.put("vehicleNumber", vehicleNumber);
      map.put("supplierNumber", supplierNumber);
      map.put("supplierDescription", supplierDescription);
      map.put("purchaseType", purchaseType);
      map.put("applicant", applicant);
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("batchNumber", batchNumber);
      map.put("samplesNumber", samplesNumber);
      map.put("samplesUnit", samplesUnit);
      map.put("samplesSource", samplesSource);
      map.put("samplers", samplers);
      map.put("expirationDate", BocpGenUtils.toTimestamp(expirationDate));
      map.put("materialNumber", materialNumber);
      map.put("materialDescribe", materialDescribe);
      map.put("deliveryNo", deliveryNo);
      map.put("totalQuantity", totalQuantity);
      map.put("unit", unit);
      map.put("vatInclusive", vatInclusive);
      map.put("currency", currency);
      map.put("disqualificationReasons", disqualificationReasons);
      map.put("creatorDomain", creatorDomain);
      map.put("purchaseDoctype", purchaseDoctype);
      map.put("processTrack", processTrack);
      map.put("adjustMode", adjustMode);
      map.put("adjustQuantity", adjustQuantity);
      map.put("adjustPrice", adjustPrice);
      map.put("adjustAmount", adjustAmount);
      map.put("companyTaxNo", companyTaxNo);
      map.put("companyName", companyName);
      map.put("supplierTaxNo", supplierTaxNo);
      map.put("supplierName", supplierName);

      return map;
  }

  public static Unqualified fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Unqualified entity = new Unqualified();
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualifiedNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncpApplyNumber")) {
      Object obj = map.get("ncpApplyNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpApplyNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("epmOrder")) {
      Object obj = map.get("epmOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEpmOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refuseReason")) {
      Object obj = map.get("refuseReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefuseReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poItemNumber")) {
      Object obj = map.get("poItemNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoItemNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleNumber")) {
      Object obj = map.get("vehicleNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierNumber")) {
      Object obj = map.get("supplierNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierDescription")) {
      Object obj = map.get("supplierDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseType")) {
      Object obj = map.get("purchaseType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicant")) {
      Object obj = map.get("applicant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("samplesNumber")) {
      Object obj = map.get("samplesNumber");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSamplesNumber((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSamplesNumber(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSamplesNumber(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSamplesNumber(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSamplesNumber(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("samplesUnit")) {
      Object obj = map.get("samplesUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamplesUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("samplesSource")) {
      Object obj = map.get("samplesSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamplesSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("samplers")) {
      Object obj = map.get("samplers");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSamplers((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expirationDate")) {
      Object obj = map.get("expirationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpirationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpirationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpirationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpirationDate(null);
      }
    }
    if(map.containsKey("materialNumber")) {
      Object obj = map.get("materialNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDescribe")) {
      Object obj = map.get("materialDescribe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryNo")) {
      Object obj = map.get("deliveryNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalQuantity")) {
      Object obj = map.get("totalQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatInclusive")) {
      Object obj = map.get("vatInclusive");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatInclusive((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatInclusive(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatInclusive(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatInclusive(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatInclusive(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("disqualificationReasons")) {
      Object obj = map.get("disqualificationReasons");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDisqualificationReasons((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creatorDomain")) {
      Object obj = map.get("creatorDomain");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatorDomain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseDoctype")) {
      Object obj = map.get("purchaseDoctype");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseDoctype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processTrack")) {
      Object obj = map.get("processTrack");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessTrack((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adjustMode")) {
      Object obj = map.get("adjustMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAdjustMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adjustQuantity")) {
      Object obj = map.get("adjustQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAdjustQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAdjustQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAdjustQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAdjustQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAdjustQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("adjustPrice")) {
      Object obj = map.get("adjustPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAdjustPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAdjustPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAdjustPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAdjustPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAdjustPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("adjustAmount")) {
      Object obj = map.get("adjustAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAdjustAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAdjustAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAdjustAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAdjustAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAdjustAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unqualifiedNumber")) {
      Object obj = map.get("unqualifiedNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualifiedNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncpApplyNumber")) {
      Object obj = map.get("ncpApplyNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpApplyNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("epmOrder")) {
      Object obj = map.get("epmOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEpmOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refuseReason")) {
      Object obj = map.get("refuseReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefuseReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poItemNumber")) {
      Object obj = map.get("poItemNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoItemNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicleNumber")) {
      Object obj = map.get("vehicleNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierNumber")) {
      Object obj = map.get("supplierNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierDescription")) {
      Object obj = map.get("supplierDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseType")) {
      Object obj = map.get("purchaseType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicant")) {
      Object obj = map.get("applicant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplicant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("samplesNumber")) {
      Object obj = map.get("samplesNumber");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSamplesNumber((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSamplesNumber(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSamplesNumber(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSamplesNumber(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSamplesNumber(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("samplesUnit")) {
      Object obj = map.get("samplesUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamplesUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("samplesSource")) {
      Object obj = map.get("samplesSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamplesSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("samplers")) {
      Object obj = map.get("samplers");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSamplers((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expirationDate")) {
      Object obj = map.get("expirationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpirationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpirationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpirationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpirationDate(null);
      }
    }
    if(map.containsKey("materialNumber")) {
      Object obj = map.get("materialNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialDescribe")) {
      Object obj = map.get("materialDescribe");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialDescribe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryNo")) {
      Object obj = map.get("deliveryNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalQuantity")) {
      Object obj = map.get("totalQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatInclusive")) {
      Object obj = map.get("vatInclusive");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatInclusive((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatInclusive(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatInclusive(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatInclusive(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatInclusive(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("disqualificationReasons")) {
      Object obj = map.get("disqualificationReasons");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDisqualificationReasons((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creatorDomain")) {
      Object obj = map.get("creatorDomain");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatorDomain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseDoctype")) {
      Object obj = map.get("purchaseDoctype");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseDoctype((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("processTrack")) {
      Object obj = map.get("processTrack");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessTrack((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("adjustMode")) {
      Object obj = map.get("adjustMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAdjustMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("adjustQuantity")) {
      Object obj = map.get("adjustQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAdjustQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAdjustQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAdjustQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAdjustQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAdjustQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("adjustPrice")) {
      Object obj = map.get("adjustPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAdjustPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAdjustPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAdjustPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAdjustPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAdjustPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("adjustAmount")) {
      Object obj = map.get("adjustAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAdjustAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAdjustAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAdjustAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAdjustAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAdjustAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
  }
}
