package com.xforceplus.jcxuhuiant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcxuhuiant.entity.PurchaserInvoice;
import com.xforceplus.jcxuhuiant.service.IPurchaserInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-22
 */
@RestController
public class PurchaserInvoiceController {

  @Autowired
  private IPurchaserInvoiceService purchaserInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaserInvoice ${table.comment}
   * @return
   */
  @GetMapping("/purchaserinvoices" )
  public XfR getPurchaserInvoices(XfPage page, PurchaserInvoice purchaserInvoice) {
    return XfR.ok(purchaserInvoiceServiceImpl.page(page, Wrappers.query(purchaserInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaserinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaserInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaserInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaserinvoices")
  public XfR save(@RequestBody PurchaserInvoice purchaserInvoice) {
     return XfR.ok(purchaserInvoiceServiceImpl.save(purchaserInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaserInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaserinvoices/{id}")
  public XfR putUpdate(@RequestBody PurchaserInvoice purchaserInvoice,@PathVariable Long id) {
      purchaserInvoice.setId(id);
      return XfR.ok(purchaserInvoiceServiceImpl.updateById(purchaserInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaserInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaserinvoices/{id}")
  public XfR patchUpdate(@RequestBody PurchaserInvoice purchaserInvoice,@PathVariable Long id) {
      PurchaserInvoice uppurchaserInvoice = purchaserInvoiceServiceImpl.getById(id);
      if(uppurchaserInvoice != null){
        uppurchaserInvoice = ObjectCopyUtils.copyProperties(purchaserInvoice,uppurchaserInvoice,true);
      }
      return XfR.ok(purchaserInvoiceServiceImpl.updateById(uppurchaserInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaserinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaserInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/purchaserinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchaser_invoice");
     params.put("request", condition);

     return XfR.ok(purchaserInvoiceServiceImpl.querys(params));
  }

}
