package com.xforceplus.jcyangolocal.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_style_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum AuthStyleEnum {

    _10("10", "平台页面勾选"),
    _11("11", "平台接口勾选"),
    _12("12", "国税底账勾选"),
    _0("0", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStyleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyleEnum fromCode(String code){
        switch(code) {
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
