package com.xforceplus.jcyangolocal.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_bill_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum BusinessBillTypeEnum {

    AR("AR", "销项业务单 "),
    AP("AP", "进项业务单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessBillTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessBillTypeEnum fromCode(String code){
        switch(code) {
            case "AR":
                return AR;
            case "AP":
                return AP;
            default:
                return null;
        }
    }
}
