package com.xforceplus.jcyangolocal.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * carryover_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum CarryoverStatusEnum {

    _0("0", "未结转"),
    _1("1", "结转中"),
    _2("2", "已结转"),
    _3("3", "结转失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CarryoverStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CarryoverStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
