package com.xforceplus.jcyangolocal.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * issue_flag_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum IssueFlagEnum {

    _1("1", "代开"),
    _0("0", "非代开");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IssueFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IssueFlagEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
