package com.xforceplus.jcyangolocal.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * print_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum PrintStatusEnum {

    _1("1", "已打印"),
    _0("0", "未打印");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PrintStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PrintStatusEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
