package com.xforceplus.jcyhxx.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyhxx.entity.InvoiceSerialNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-yhxx")
public interface InvoiceSerialNoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceSerialNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceSerialNo ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceSerialNo/add")
  public R save(@RequestBody InvoiceSerialNo invoiceSerialNo);

  /**
   * 修改${table.comment}
   * @param invoiceSerialNo ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceSerialNo/update")
  public R updateById(@RequestBody InvoiceSerialNo invoiceSerialNo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceSerialNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}