package com.xforceplus.jcyhxx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyhxx.entity.SystemValidateCode;
import com.xforceplus.jcyhxx.service.ISystemValidateCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统验证码前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class SystemValidateCodeController {

  @Autowired
  private ISystemValidateCodeService systemValidateCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemValidateCode 系统验证码
   * @return
   */
  @GetMapping("/systemvalidatecodes" )
  public XfR getSystemValidateCodes(XfPage page, SystemValidateCode systemValidateCode) {
    return XfR.ok(systemValidateCodeServiceImpl.page(page, Wrappers.query(systemValidateCode)));
  }

  /**
   * 通过id查询系统验证码
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemvalidatecodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemValidateCodeServiceImpl.getById(id));
  }

  /**
   * 新增系统验证码
   * @param systemValidateCode 系统验证码
   * @return XfR
   */
  @PostMapping("/systemvalidatecodes")
  public XfR save(@RequestBody SystemValidateCode systemValidateCode) {
     return XfR.ok(systemValidateCodeServiceImpl.save(systemValidateCode));
  }

  /**
   * 修改-传入修改后的全部数据系统验证码
   * @param systemValidateCode 系统验证码
   * @return XfR
   */
  @PutMapping("/systemvalidatecodes/{id}")
  public XfR putUpdate(@RequestBody SystemValidateCode systemValidateCode,@PathVariable Long id) {
      systemValidateCode.setId(id);
      return XfR.ok(systemValidateCodeServiceImpl.updateById(systemValidateCode));
  }

  /**
   * 修改-传入修改的数据系统验证码
   * @param systemValidateCode 系统验证码
   * @return XfR
   */
  @PatchMapping("/systemvalidatecodes/{id}")
  public XfR patchUpdate(@RequestBody SystemValidateCode systemValidateCode,@PathVariable Long id) {
      SystemValidateCode upsystemValidateCode = systemValidateCodeServiceImpl.getById(id);
      if(upsystemValidateCode != null){
        upsystemValidateCode = ObjectCopyUtils.copyProperties(systemValidateCode,upsystemValidateCode,true);
      }
      return XfR.ok(systemValidateCodeServiceImpl.updateById(upsystemValidateCode));
  }

  /**
   * 通过id删除系统验证码
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemvalidatecodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemValidateCodeServiceImpl.removeById(id));
  }

  @PostMapping("/systemvalidatecodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_validate_code");
     params.put("request", condition);

     return XfR.ok(systemValidateCodeServiceImpl.querys(params));
  }

}
