package com.xforceplus.jcyhxx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyhxx.entity.SysFlowTask;
import com.xforceplus.jcyhxx.service.ISysFlowTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统用户任务对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class SysFlowTaskController {

  @Autowired
  private ISysFlowTaskService sysFlowTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowTask 系统用户任务对象
   * @return
   */
  @GetMapping("/sysflowtasks" )
  public XfR getSysFlowTasks(XfPage page, SysFlowTask sysFlowTask) {
    return XfR.ok(sysFlowTaskServiceImpl.page(page, Wrappers.query(sysFlowTask)));
  }

  /**
   * 通过id查询系统用户任务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowtasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowTaskServiceImpl.getById(id));
  }

  /**
   * 新增系统用户任务对象
   * @param sysFlowTask 系统用户任务对象
   * @return XfR
   */
  @PostMapping("/sysflowtasks")
  public XfR save(@RequestBody SysFlowTask sysFlowTask) {
     return XfR.ok(sysFlowTaskServiceImpl.save(sysFlowTask));
  }

  /**
   * 修改-传入修改后的全部数据系统用户任务对象
   * @param sysFlowTask 系统用户任务对象
   * @return XfR
   */
  @PutMapping("/sysflowtasks/{id}")
  public XfR putUpdate(@RequestBody SysFlowTask sysFlowTask,@PathVariable Long id) {
      sysFlowTask.setId(id);
      return XfR.ok(sysFlowTaskServiceImpl.updateById(sysFlowTask));
  }

  /**
   * 修改-传入修改的数据系统用户任务对象
   * @param sysFlowTask 系统用户任务对象
   * @return XfR
   */
  @PatchMapping("/sysflowtasks/{id}")
  public XfR patchUpdate(@RequestBody SysFlowTask sysFlowTask,@PathVariable Long id) {
      SysFlowTask upsysFlowTask = sysFlowTaskServiceImpl.getById(id);
      if(upsysFlowTask != null){
        upsysFlowTask = ObjectCopyUtils.copyProperties(sysFlowTask,upsysFlowTask,true);
      }
      return XfR.ok(sysFlowTaskServiceImpl.updateById(upsysFlowTask));
  }

  /**
   * 通过id删除系统用户任务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowtasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowTaskServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowtasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_task");
     params.put("request", condition);

     return XfR.ok(sysFlowTaskServiceImpl.querys(params));
  }

}
