package com.xforceplus.jcyhxx.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyhxx.entity.DoInfo;
import com.xforceplus.jcyhxx.service.IDoInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-05
 */
@RestController
public class DoInfoController {

  @Autowired
  private IDoInfoService doInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param doInfo ${table.comment}
   * @return
   */
  @GetMapping("/doinfos" )
  public XfR getDoInfos(XfPage page, DoInfo doInfo) {
    return XfR.ok(doInfoServiceImpl.page(page, Wrappers.query(doInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/doinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(doInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param doInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/doinfos")
  public XfR save(@RequestBody DoInfo doInfo) {
     return XfR.ok(doInfoServiceImpl.save(doInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param doInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/doinfos/{id}")
  public XfR putUpdate(@RequestBody DoInfo doInfo,@PathVariable Long id) {
      doInfo.setId(id);
      return XfR.ok(doInfoServiceImpl.updateById(doInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param doInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/doinfos/{id}")
  public XfR patchUpdate(@RequestBody DoInfo doInfo,@PathVariable Long id) {
      DoInfo updoInfo = doInfoServiceImpl.getById(id);
      if(updoInfo != null){
        updoInfo = ObjectCopyUtils.copyProperties(doInfo,updoInfo,true);
      }
      return XfR.ok(doInfoServiceImpl.updateById(updoInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/doinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(doInfoServiceImpl.removeById(id));
  }

  @PostMapping("/doinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "do_info");
     params.put("request", condition);

     return XfR.ok(doInfoServiceImpl.querys(params));
  }

}
