package com.xforceplus.jcyinyue.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-06-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyinyue.entity.BillRedNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-yinyue")
public interface BillRedNoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/billRedNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param billRedNo ${table.comment}
   * @return R
   */
  @PostMapping("/billRedNo/add")
  public R save(@RequestBody BillRedNo billRedNo);

  /**
   * 修改${table.comment}
   * @param billRedNo ${table.comment}
   * @return R
   */
  @PostMapping("/billRedNo/update")
  public R updateById(@RequestBody BillRedNo billRedNo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/billRedNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}