package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.Hotel;
import com.xforceplus.jcyuanhang.service.IHotelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class HotelController {

  @Autowired
  private IHotelService hotelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param hotel ${table.comment}
   * @return
   */
  @GetMapping("/hotels" )
  public XfR getHotels(XfPage page, Hotel hotel) {
    return XfR.ok(hotelServiceImpl.page(page, Wrappers.query(hotel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/hotels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(hotelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param hotel ${table.comment}
   * @return XfR
   */
  @PostMapping("/hotels")
  public XfR save(@RequestBody Hotel hotel) {
     return XfR.ok(hotelServiceImpl.save(hotel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param hotel ${table.comment}
   * @return XfR
   */
  @PutMapping("/hotels/{id}")
  public XfR putUpdate(@RequestBody Hotel hotel,@PathVariable Long id) {
      hotel.setId(id);
      return XfR.ok(hotelServiceImpl.updateById(hotel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param hotel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/hotels/{id}")
  public XfR patchUpdate(@RequestBody Hotel hotel,@PathVariable Long id) {
      Hotel uphotel = hotelServiceImpl.getById(id);
      if(uphotel != null){
        uphotel = ObjectCopyUtils.copyProperties(hotel,uphotel,true);
      }
      return XfR.ok(hotelServiceImpl.updateById(uphotel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/hotels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(hotelServiceImpl.removeById(id));
  }

  @PostMapping("/hotels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "hotel");
     params.put("request", condition);

     return XfR.ok(hotelServiceImpl.querys(params));
  }

}
