package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.OqsTest;
import com.xforceplus.jcyuanhang.service.IOqsTestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class OqsTestController {

  @Autowired
  private IOqsTestService oqsTestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsTest ${table.comment}
   * @return
   */
  @GetMapping("/oqstests" )
  public XfR getOqsTests(XfPage page, OqsTest oqsTest) {
    return XfR.ok(oqsTestServiceImpl.page(page, Wrappers.query(oqsTest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqstests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsTestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oqsTest ${table.comment}
   * @return XfR
   */
  @PostMapping("/oqstests")
  public XfR save(@RequestBody OqsTest oqsTest) {
     return XfR.ok(oqsTestServiceImpl.save(oqsTest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oqsTest ${table.comment}
   * @return XfR
   */
  @PutMapping("/oqstests/{id}")
  public XfR putUpdate(@RequestBody OqsTest oqsTest,@PathVariable Long id) {
      oqsTest.setId(id);
      return XfR.ok(oqsTestServiceImpl.updateById(oqsTest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oqsTest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oqstests/{id}")
  public XfR patchUpdate(@RequestBody OqsTest oqsTest,@PathVariable Long id) {
      OqsTest upoqsTest = oqsTestServiceImpl.getById(id);
      if(upoqsTest != null){
        upoqsTest = ObjectCopyUtils.copyProperties(oqsTest,upoqsTest,true);
      }
      return XfR.ok(oqsTestServiceImpl.updateById(upoqsTest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqstests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsTestServiceImpl.removeById(id));
  }

  @PostMapping("/oqstests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqs_test");
     params.put("request", condition);

     return XfR.ok(oqsTestServiceImpl.querys(params));
  }

}
