package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.RedNoObj;
import com.xforceplus.jcyuanhang.service.IRedNoObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class RedNoObjController {

  @Autowired
  private IRedNoObjService redNoObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redNoObj ${table.comment}
   * @return
   */
  @GetMapping("/rednoobjs" )
  public XfR getRedNoObjs(XfPage page, RedNoObj redNoObj) {
    return XfR.ok(redNoObjServiceImpl.page(page, Wrappers.query(redNoObj)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rednoobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redNoObjServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redNoObj ${table.comment}
   * @return XfR
   */
  @PostMapping("/rednoobjs")
  public XfR save(@RequestBody RedNoObj redNoObj) {
     return XfR.ok(redNoObjServiceImpl.save(redNoObj));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redNoObj ${table.comment}
   * @return XfR
   */
  @PutMapping("/rednoobjs/{id}")
  public XfR putUpdate(@RequestBody RedNoObj redNoObj,@PathVariable Long id) {
      redNoObj.setId(id);
      return XfR.ok(redNoObjServiceImpl.updateById(redNoObj));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redNoObj ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rednoobjs/{id}")
  public XfR patchUpdate(@RequestBody RedNoObj redNoObj,@PathVariable Long id) {
      RedNoObj upredNoObj = redNoObjServiceImpl.getById(id);
      if(upredNoObj != null){
        upredNoObj = ObjectCopyUtils.copyProperties(redNoObj,upredNoObj,true);
      }
      return XfR.ok(redNoObjServiceImpl.updateById(upredNoObj));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rednoobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redNoObjServiceImpl.removeById(id));
  }

  @PostMapping("/rednoobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_no_obj");
     params.put("request", condition);

     return XfR.ok(redNoObjServiceImpl.querys(params));
  }

}
