package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.Testheader;
import com.xforceplus.jcyuanhang.service.ITestheaderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class TestheaderController {

  @Autowired
  private ITestheaderService testheaderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testheader ${table.comment}
   * @return
   */
  @GetMapping("/testheaders" )
  public XfR getTestheaders(XfPage page, Testheader testheader) {
    return XfR.ok(testheaderServiceImpl.page(page, Wrappers.query(testheader)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testheaders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testheaderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testheader ${table.comment}
   * @return XfR
   */
  @PostMapping("/testheaders")
  public XfR save(@RequestBody Testheader testheader) {
     return XfR.ok(testheaderServiceImpl.save(testheader));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testheader ${table.comment}
   * @return XfR
   */
  @PutMapping("/testheaders/{id}")
  public XfR putUpdate(@RequestBody Testheader testheader,@PathVariable Long id) {
      testheader.setId(id);
      return XfR.ok(testheaderServiceImpl.updateById(testheader));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testheader ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testheaders/{id}")
  public XfR patchUpdate(@RequestBody Testheader testheader,@PathVariable Long id) {
      Testheader uptestheader = testheaderServiceImpl.getById(id);
      if(uptestheader != null){
        uptestheader = ObjectCopyUtils.copyProperties(testheader,uptestheader,true);
      }
      return XfR.ok(testheaderServiceImpl.updateById(uptestheader));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testheaders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testheaderServiceImpl.removeById(id));
  }

  @PostMapping("/testheaders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testheader");
     params.put("request", condition);

     return XfR.ok(testheaderServiceImpl.querys(params));
  }

}
