package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.Testline1;
import com.xforceplus.jcyuanhang.service.ITestline1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class Testline1Controller {

  @Autowired
  private ITestline1Service testline1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testline1 ${table.comment}
   * @return
   */
  @GetMapping("/testline1s" )
  public XfR getTestline1s(XfPage page, Testline1 testline1) {
    return XfR.ok(testline1ServiceImpl.page(page, Wrappers.query(testline1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testline1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testline1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testline1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testline1s")
  public XfR save(@RequestBody Testline1 testline1) {
     return XfR.ok(testline1ServiceImpl.save(testline1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testline1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testline1s/{id}")
  public XfR putUpdate(@RequestBody Testline1 testline1,@PathVariable Long id) {
      testline1.setId(id);
      return XfR.ok(testline1ServiceImpl.updateById(testline1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testline1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testline1s/{id}")
  public XfR patchUpdate(@RequestBody Testline1 testline1,@PathVariable Long id) {
      Testline1 uptestline1 = testline1ServiceImpl.getById(id);
      if(uptestline1 != null){
        uptestline1 = ObjectCopyUtils.copyProperties(testline1,uptestline1,true);
      }
      return XfR.ok(testline1ServiceImpl.updateById(uptestline1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testline1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testline1ServiceImpl.removeById(id));
  }

  @PostMapping("/testline1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testline1");
     params.put("request", condition);

     return XfR.ok(testline1ServiceImpl.querys(params));
  }

}
