package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.Testline2;
import com.xforceplus.jcyuanhang.service.ITestline2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class Testline2Controller {

  @Autowired
  private ITestline2Service testline2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testline2 ${table.comment}
   * @return
   */
  @GetMapping("/testline2s" )
  public XfR getTestline2s(XfPage page, Testline2 testline2) {
    return XfR.ok(testline2ServiceImpl.page(page, Wrappers.query(testline2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testline2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testline2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testline2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testline2s")
  public XfR save(@RequestBody Testline2 testline2) {
     return XfR.ok(testline2ServiceImpl.save(testline2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testline2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testline2s/{id}")
  public XfR putUpdate(@RequestBody Testline2 testline2,@PathVariable Long id) {
      testline2.setId(id);
      return XfR.ok(testline2ServiceImpl.updateById(testline2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testline2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testline2s/{id}")
  public XfR patchUpdate(@RequestBody Testline2 testline2,@PathVariable Long id) {
      Testline2 uptestline2 = testline2ServiceImpl.getById(id);
      if(uptestline2 != null){
        uptestline2 = ObjectCopyUtils.copyProperties(testline2,uptestline2,true);
      }
      return XfR.ok(testline2ServiceImpl.updateById(uptestline2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testline2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testline2ServiceImpl.removeById(id));
  }

  @PostMapping("/testline2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testline2");
     params.put("request", condition);

     return XfR.ok(testline2ServiceImpl.querys(params));
  }

}
