package com.xforceplus.jcyuanhang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcyuanhang.entity.Yyh;
import com.xforceplus.jcyuanhang.service.IYyhService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class YyhController {

  @Autowired
  private IYyhService yyhServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yyh ${table.comment}
   * @return
   */
  @GetMapping("/yyhs" )
  public XfR getYyhs(XfPage page, Yyh yyh) {
    return XfR.ok(yyhServiceImpl.page(page, Wrappers.query(yyh)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/yyhs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yyhServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param yyh ${table.comment}
   * @return XfR
   */
  @PostMapping("/yyhs")
  public XfR save(@RequestBody Yyh yyh) {
     return XfR.ok(yyhServiceImpl.save(yyh));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param yyh ${table.comment}
   * @return XfR
   */
  @PutMapping("/yyhs/{id}")
  public XfR putUpdate(@RequestBody Yyh yyh,@PathVariable Long id) {
      yyh.setId(id);
      return XfR.ok(yyhServiceImpl.updateById(yyh));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param yyh ${table.comment}
   * @return XfR
   */
  @PatchMapping("/yyhs/{id}")
  public XfR patchUpdate(@RequestBody Yyh yyh,@PathVariable Long id) {
      Yyh upyyh = yyhServiceImpl.getById(id);
      if(upyyh != null){
        upyyh = ObjectCopyUtils.copyProperties(yyh,upyyh,true);
      }
      return XfR.ok(yyhServiceImpl.updateById(upyyh));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yyhs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yyhServiceImpl.removeById(id));
  }

  @PostMapping("/yyhs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yyh");
     params.put("request", condition);

     return XfR.ok(yyhServiceImpl.querys(params));
  }

}
