package com.xforceplus.jczkh.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jczkh.entity.InvoiceInvalidLogger;
import com.xforceplus.jczkh.service.IInvoiceInvalidLoggerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-14
 */
@RestController
public class InvoiceInvalidLoggerController {

  @Autowired
  private IInvoiceInvalidLoggerService invoiceInvalidLoggerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceInvalidLogger ${table.comment}
   * @return
   */
  @GetMapping("/invoiceinvalidloggers" )
  public XfR getInvoiceInvalidLoggers(XfPage page, InvoiceInvalidLogger invoiceInvalidLogger) {
    return XfR.ok(invoiceInvalidLoggerServiceImpl.page(page, Wrappers.query(invoiceInvalidLogger)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceinvalidloggers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceInvalidLoggerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceInvalidLogger ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceinvalidloggers")
  public XfR save(@RequestBody InvoiceInvalidLogger invoiceInvalidLogger) {
     return XfR.ok(invoiceInvalidLoggerServiceImpl.save(invoiceInvalidLogger));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceInvalidLogger ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceinvalidloggers/{id}")
  public XfR putUpdate(@RequestBody InvoiceInvalidLogger invoiceInvalidLogger,@PathVariable Long id) {
      invoiceInvalidLogger.setId(id);
      return XfR.ok(invoiceInvalidLoggerServiceImpl.updateById(invoiceInvalidLogger));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceInvalidLogger ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceinvalidloggers/{id}")
  public XfR patchUpdate(@RequestBody InvoiceInvalidLogger invoiceInvalidLogger,@PathVariable Long id) {
      InvoiceInvalidLogger upinvoiceInvalidLogger = invoiceInvalidLoggerServiceImpl.getById(id);
      if(upinvoiceInvalidLogger != null){
        upinvoiceInvalidLogger = ObjectCopyUtils.copyProperties(invoiceInvalidLogger,upinvoiceInvalidLogger,true);
      }
      return XfR.ok(invoiceInvalidLoggerServiceImpl.updateById(upinvoiceInvalidLogger));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceinvalidloggers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceInvalidLoggerServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceinvalidloggers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_invalid_logger");
     params.put("request", condition);

     return XfR.ok(invoiceInvalidLoggerServiceImpl.querys(params));
  }

}
