package com.xforceplus.ksfnoodles.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * interface_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
public enum InterfaceStatus {

    FALSE("false", "否"),
    TRUE("true", "是"),
    ERROR("error", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InterfaceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InterfaceStatus fromCode(String code){
        switch(code) {
            case "false":
                return FALSE;
            case "true":
                return TRUE;
            case "error":
                return ERROR;
            default:
                return null;
        }
    }
}
