package com.xforceplus.ksfnoodles.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_enabled
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
public enum IsEnabled {

    ENABLED("enabled", "开启（默认）"),
    DISABLED("disabled", "关闭/停止");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IsEnabled(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsEnabled fromCode(String code){
        switch(code) {
            case "enabled":
                return ENABLED;
            case "disabled":
                return DISABLED;
            default:
                return null;
        }
    }
}
