package com.xforceplus.ksfnoodles.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_valid
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
public enum IsValid {

    VALID("valid", "有效（默认）"),
    INVALID("invalid", "无效");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IsValid(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsValid fromCode(String code){
        switch(code) {
            case "valid":
                return VALID;
            case "invalid":
                return INVALID;
            default:
                return null;
        }
    }
}
