package com.xforceplus.ksfnoodles.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 康师傅方便面业务-门店主数据实对象
 * </p>
 *
 * @author ultraman
 * @since 2025-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmStore implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 门店编码
   */
  @TableField("storeCode")
  private String storeCode;

  /**
   * 门店名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * 外部编码
   */
  @TableField("extCode")
  private String extCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 分段代码
   */
  @TableField("subCode")
  private String subCode;

  /**
   * 上级门店编码
   */
  @TableField("parentStoreCode")
  private String parentStoreCode;

  /**
   * 上级门店名称
   */
  @TableField("parentStoreName")
  private String parentStoreName;

  /**
   * KA编码
   */
  @TableField("distCode")
  private String distCode;

  /**
   * KA名称
   */
  @TableField("distName")
  private String distName;

  /**
   * 组织编码
   */
  @TableField("orgCode")
  private String orgCode;

  /**
   * 组织名称
   */
  @TableField("orgName")
  private String orgName;

  /**
   * 省份名称
   */
  @TableField("geoProvinceName")
  private String geoProvinceName;

  /**
   * 省份编码
   */
  @TableField("geoprovinceCode")
  private String geoprovinceCode;

  /**
   * 市级名称
   */
  @TableField("geoCityName")
  private String geoCityName;

  /**
   * 市级编码
   */
  @TableField("geoCityCode")
  private String geoCityCode;

  /**
   * 区县名称
   */
  @TableField("geoCountyName")
  private String geoCountyName;

  /**
   * 区县编码
   */
  @TableField("geoCountyCode")
  private String geoCountyCode;

  /**
   * 地理区域
   */
  @TableField("geoName")
  private String geoName;

  /**
   * 地理区域编码
   */
  @TableField("geoCode")
  private String geoCode;

  /**
   * 门店类型编码
   */
  @TableField("storeTypeCode")
  private String storeTypeCode;

  /**
   * 门店类型名称
   */
  @TableField("storeTypeName")
  private String storeTypeName;

  /**
   * 门店性质编码
   */
  @TableField("natureCode")
  private String natureCode;

  /**
   * 门店性质名称
   */
  @TableField("natureName")
  private String natureName;

  /**
   * 门店组织编码
   */
  @TableField("corpCode")
  private String corpCode;

  /**
   * 门店组织名称
   */
  @TableField("corpName")
  private String corpName;

  /**
   * 其它分类编码
   */
  @TableField("otherCode")
  private String otherCode;

  /**
   * 其它分类名称
   */
  @TableField("otherName")
  private String otherName;

  /**
   * 门店渠道编码
   */
  @TableField("channelCode")
  private String channelCode;

  /**
   * 门店渠道名称
   */
  @TableField("channelName")
  private String channelName;

  /**
   * 门店地址
   */
  @TableField("storeAddress")
  private String storeAddress;

  /**
   * 联系人
   */
  private String linkman;

  /**
   * 联系电话
   */
  @TableField("linkTel")
  private String linkTel;

  /**
   * 状态(是|否)
   */
  private String state;

  /**
   * 门店业务状态(正常|关闭)
   */
  @TableField("businessState")
  private String businessState;

  /**
   * 备注1
   */
  private String memo1;

  /**
   * 更新时间（格式：yyyy-MM-dd HH:mm:ss）
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updated;

  /**
   * 门店Id
   */
  @TableField("storeId")
  private String storeId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("storeCode", storeCode);
      map.put("storeName", storeName);
      map.put("extCode", extCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("subCode", subCode);
      map.put("parentStoreCode", parentStoreCode);
      map.put("parentStoreName", parentStoreName);
      map.put("distCode", distCode);
      map.put("distName", distName);
      map.put("orgCode", orgCode);
      map.put("orgName", orgName);
      map.put("geoProvinceName", geoProvinceName);
      map.put("geoprovinceCode", geoprovinceCode);
      map.put("geoCityName", geoCityName);
      map.put("geoCityCode", geoCityCode);
      map.put("geoCountyName", geoCountyName);
      map.put("geoCountyCode", geoCountyCode);
      map.put("geoName", geoName);
      map.put("geoCode", geoCode);
      map.put("storeTypeCode", storeTypeCode);
      map.put("storeTypeName", storeTypeName);
      map.put("natureCode", natureCode);
      map.put("natureName", natureName);
      map.put("corpCode", corpCode);
      map.put("corpName", corpName);
      map.put("otherCode", otherCode);
      map.put("otherName", otherName);
      map.put("channelCode", channelCode);
      map.put("channelName", channelName);
      map.put("storeAddress", storeAddress);
      map.put("linkman", linkman);
      map.put("linkTel", linkTel);
      map.put("state", state);
      map.put("businessState", businessState);
      map.put("memo1", memo1);
      map.put("updated", BocpGenUtils.toTimestamp(updated));
      map.put("storeId", storeId);

      return map;
  }

  public static MdmStore fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MdmStore entity = new MdmStore();
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extCode")) {
      Object obj = map.get("extCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subCode")) {
      Object obj = map.get("subCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentStoreCode")) {
      Object obj = map.get("parentStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentStoreName")) {
      Object obj = map.get("parentStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgName")) {
      Object obj = map.get("orgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoProvinceName")) {
      Object obj = map.get("geoProvinceName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoProvinceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoprovinceCode")) {
      Object obj = map.get("geoprovinceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoprovinceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoCityName")) {
      Object obj = map.get("geoCityName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoCityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoCityCode")) {
      Object obj = map.get("geoCityCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoCityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoCountyName")) {
      Object obj = map.get("geoCountyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoCountyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoCountyCode")) {
      Object obj = map.get("geoCountyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoCountyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoName")) {
      Object obj = map.get("geoName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("geoCode")) {
      Object obj = map.get("geoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGeoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeTypeCode")) {
      Object obj = map.get("storeTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeTypeName")) {
      Object obj = map.get("storeTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("natureCode")) {
      Object obj = map.get("natureCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNatureCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("natureName")) {
      Object obj = map.get("natureName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNatureName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("corpCode")) {
      Object obj = map.get("corpCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCorpCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("corpName")) {
      Object obj = map.get("corpName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCorpName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherCode")) {
      Object obj = map.get("otherCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherName")) {
      Object obj = map.get("otherName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelCode")) {
      Object obj = map.get("channelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelName")) {
      Object obj = map.get("channelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeAddress")) {
      Object obj = map.get("storeAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("linkman")) {
      Object obj = map.get("linkman");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLinkman((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("linkTel")) {
      Object obj = map.get("linkTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLinkTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessState")) {
      Object obj = map.get("businessState");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo1")) {
      Object obj = map.get("memo1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMemo1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updated")) {
      Object obj = map.get("updated");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdated(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdated((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdated(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdated(null);
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extCode")) {
      Object obj = map.get("extCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subCode")) {
      Object obj = map.get("subCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parentStoreCode")) {
      Object obj = map.get("parentStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParentStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parentStoreName")) {
      Object obj = map.get("parentStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParentStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distCode")) {
      Object obj = map.get("distCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distName")) {
      Object obj = map.get("distName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orgName")) {
      Object obj = map.get("orgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoProvinceName")) {
      Object obj = map.get("geoProvinceName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoProvinceName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoprovinceCode")) {
      Object obj = map.get("geoprovinceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoprovinceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoCityName")) {
      Object obj = map.get("geoCityName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoCityName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoCityCode")) {
      Object obj = map.get("geoCityCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoCityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoCountyName")) {
      Object obj = map.get("geoCountyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoCountyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoCountyCode")) {
      Object obj = map.get("geoCountyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoCountyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoName")) {
      Object obj = map.get("geoName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("geoCode")) {
      Object obj = map.get("geoCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGeoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeTypeCode")) {
      Object obj = map.get("storeTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeTypeName")) {
      Object obj = map.get("storeTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("natureCode")) {
      Object obj = map.get("natureCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNatureCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("natureName")) {
      Object obj = map.get("natureName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNatureName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("corpCode")) {
      Object obj = map.get("corpCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCorpCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("corpName")) {
      Object obj = map.get("corpName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCorpName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("otherCode")) {
      Object obj = map.get("otherCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOtherCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("otherName")) {
      Object obj = map.get("otherName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOtherName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channelCode")) {
      Object obj = map.get("channelCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channelName")) {
      Object obj = map.get("channelName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeAddress")) {
      Object obj = map.get("storeAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("linkman")) {
      Object obj = map.get("linkman");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLinkman((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("linkTel")) {
      Object obj = map.get("linkTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLinkTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String) {
          this.setState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessState")) {
      Object obj = map.get("businessState");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("memo1")) {
      Object obj = map.get("memo1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMemo1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("updated")) {
      Object obj = map.get("updated");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdated(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdated((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdated(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdated(null);
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
  }
}
