package com.xforceplus.lted.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.lted.entity.Dev;
import com.xforceplus.lted.service.IDevService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-07
 */
@RestController
public class DevController {

  @Autowired
  private IDevService devServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dev ${table.comment}
   * @return
   */
  @GetMapping("/devs" )
  public XfR getDevs(XfPage page, Dev dev) {
    return XfR.ok(devServiceImpl.page(page, Wrappers.query(dev)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/devs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(devServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dev ${table.comment}
   * @return XfR
   */
  @PostMapping("/devs")
  public XfR save(@RequestBody Dev dev) {
     return XfR.ok(devServiceImpl.save(dev));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dev ${table.comment}
   * @return XfR
   */
  @PutMapping("/devs/{id}")
  public XfR putUpdate(@RequestBody Dev dev,@PathVariable Long id) {
      dev.setId(id);
      return XfR.ok(devServiceImpl.updateById(dev));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dev ${table.comment}
   * @return XfR
   */
  @PatchMapping("/devs/{id}")
  public XfR patchUpdate(@RequestBody Dev dev,@PathVariable Long id) {
      Dev updev = devServiceImpl.getById(id);
      if(updev != null){
        updev = ObjectCopyUtils.copyProperties(dev,updev,true);
      }
      return XfR.ok(devServiceImpl.updateById(updev));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/devs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(devServiceImpl.removeById(id));
  }

  @PostMapping("/devs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dev");
     params.put("request", condition);

     return XfR.ok(devServiceImpl.querys(params));
  }

}
