/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.feign;

import com.xforceplus.phoenix.cache.util.RedisUtil;
import com.xforceplus.phoenix.match.bean.MsLoginRequest;
import com.xforceplus.phoenix.match.bean.MsResponse;
import com.xforceplus.phoenix.match.client.LoginApi;
import com.xforceplus.phoenix.tools.util.NullableUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenInterceptor.class);
    private final LoginApi accessClient;
    private final String clientId;
    private final String secret;
    private final String gatewayUrl;
    private final String userCenterUrl;
    private RedisUtil redisUtil;
    private static final String ACCESS_TOKEN_KEY = "authServiceAccessTokenKey";
    private String tokenAttribution;

    public AccessTokenInterceptor(LoginApi accessClient, String clientId, String secret, RedisUtil redisUtil, String gatewayUrl, String userCenterUrl, String tokenAttribution) {
        this.accessClient = accessClient;
        this.clientId = clientId;
        this.secret = secret;
        this.redisUtil = redisUtil;
        this.gatewayUrl = gatewayUrl;
        this.userCenterUrl = userCenterUrl;
        this.tokenAttribution = tokenAttribution;
    }

    public void apply(RequestTemplate template) {
        template.header("x-app-token", new String[]{this.getTokenWithCache(this.tokenAttribution)});
    }

    private String getTokenWithCache(String tokenAttribution) {
        log.info("matchService\u83b7\u53d6\u4e2d\u53f0\u7f51\u5173token\u5165\u53c2,clientId:{},secret:{},gatewayUrl:{},userCenterUrl:{},tokenAttribution:{}", new Object[]{this.clientId, this.secret, this.gatewayUrl, this.userCenterUrl, tokenAttribution});
        String token = NullableUtil.toStringValue((Object)this.redisUtil.get(ACCESS_TOKEN_KEY + tokenAttribution), (String)"");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            log.info("matchService\u7f13\u5b58\u4e2d\u83b7\u53d6\u4e2d\u53f0\u7f51\u5173token:{}", (Object)token);
            return token;
        }
        try {
            MsResponse loginResponse = this.accessClient.login(new MsLoginRequest(this.clientId, this.secret));
            if (1 == loginResponse.getCode()) {
                token = loginResponse.getData();
                this.redisUtil.set(ACCESS_TOKEN_KEY + tokenAttribution, (Object)token, 14400L);
            }
            log.info("matchService\u975e\u7f13\u5b58\u4e2d\u83b7\u53d6\u4e2d\u53f0\u7f51\u5173token:{}", (Object)token);
        }
        catch (Exception e) {
            log.error("matchService\u83b7\u53d6\u4e2d\u53f0\u7f51\u5173token\u5f02\u5e38clientId:{},secret:{},userCenterUrl:{},\u5f02\u5e38\u539f\u56e0:{}", new Object[]{this.clientId, this.secret, this.userCenterUrl, e});
        }
        return token;
    }
}

