/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.feign;

import com.xforceplus.phoenix.match.common.feign.ApiClient;
import com.xforceplus.phoenix.match.common.feign.FeignErrorDecoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;

public class ApiClient {
    private String basePath = "http://localhost:8090";
    private Feign.Builder feignBuilder;

    public ApiClient(Request.Options options, okhttp3.OkHttpClient okHttpClient) {
        this.feignBuilder = Feign.builder().client((Client)new OkHttpClient(okHttpClient)).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).options(options).logger((Logger)new Slf4jLogger());
    }

    public ApiClient basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ApiClient requestInterceptor(RequestInterceptor requestInterceptor) {
        this.feignBuilder.requestInterceptor(requestInterceptor);
        return this;
    }

    public <T extends Api> T buildClient(Class<T> clientClass) {
        return (T)((Api)this.feignBuilder.target(clientClass, this.basePath));
    }

    public ApiClient getFeignBuilder(FeignErrorDecoder feignErrorDecoder) {
        this.feignBuilder.errorDecoder((ErrorDecoder)feignErrorDecoder);
        return this;
    }
}

