/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.feign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.phoenix.match.exception.MyFeignException;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class FeignErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        String code = "500";
        String message = "\u8fdc\u7a0b\u63a5\u53e3\u8c03\u7528\u5f02\u5e38";
        String result = "";
        if (response.status() != HttpStatus.OK.value()) {
            try {
                String body = Util.toString((Reader)response.body().asReader());
                JSONObject jsonObject = JSON.parseObject((String)body);
                if (jsonObject != null) {
                    code = jsonObject.getString("code");
                    message = jsonObject.getString("message");
                    result = jsonObject.getString("result");
                }
            }
            catch (Exception e) {
                log.error("FeignErrorDecoder\u5f02\u5e38:{}", (Throwable)e);
            }
        }
        return new MyFeignException(code, message, result);
    }
}

