/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.mapstruct;

import com.google.api.client.util.Lists;
import com.xforceplus.phoenix.match.client.model.match.BillErrorVO;
import com.xforceplus.phoenix.match.client.model.match.BillVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceBillListErrorVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceErrorVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceVO;
import com.xforceplus.phoenix.match.client.model.match.MatchRelationVO;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.pim.client.model.MsDetailListResponse;
import com.xforceplus.phoenix.pim.client.model.MsDetailRow;
import com.xforceplus.phoenix.pim.client.model.MsMatchBean;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceDetailRow;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", imports={Date.class})
public interface MatchMapper {
    default public Long dateToLong(Date date) {
        return date == null ? null : Long.valueOf(date.getTime());
    }

    @BeanMapping(ignoreByDefault=true)
    @Mappings(value={@Mapping(target="bussinessNo", source="entity.salesbillNo"), @Mapping(target="bussinessId", source="entity.salesbillId"), @Mapping(target="cooperateFlag", expression="java(entity.getCooperateFlag() == 1 ? true : false)"), @Mapping(target="salesbillType", source="entity.salesbillType"), @Mapping(target="salesbillChargeUpStatus", source="entity.chargeUpStatus"), @Mapping(target="salesbillChargeUpNo", source="entity.chargeUpNo"), @Mapping(target="invoiceId", source="invoiceId"), @Mapping(target="matchAmount", source="matchAmount"), @Mapping(target="matchType", source="matchType")})
    public MsMatchBean toMsMatchBean(MtcSalesbillEntity var1, Long var2, BigDecimal var3, Integer var4);

    @Mapping(target="sellerOrigin", source="entity.invoiceSellerOrigin")
    public MatchRelationVO toMatchRelationVo(MtcSalesbillInvoiceEntity var1, List<MsPimInvoiceDetailRow> var2);

    @Mapping(target="sellerOrigin", source="entity.invoiceSellerOrigin")
    public MatchRelationVO matchRelationVo(MtcSalesbillInvoiceEntity var1, List<MsDetailRow> var2);

    default public List<MatchRelationVO> toMatchRelationVo(List<MtcSalesbillInvoiceEntity> entities, Function<Long, MsDetailListResponse> func) {
        List<MatchRelationVO> list = entities.parallelStream().map(invoice -> {
            MsDetailListResponse response = (MsDetailListResponse)func.apply(invoice.getInvoiceId());
            MatchRelationVO matchRelationVO = this.matchRelationVo(invoice, response.getResult());
            matchRelationVO.setItemTotal(response.getTotal());
            matchRelationVO.setItemMatchStatusTotal(response.getMatchErrTotal());
            return matchRelationVO;
        }).collect(Collectors.toList());
        return list;
    }

    default public List<MatchRelationVO> toMatchRelationVo(List<MtcSalesbillEntity> billEntities, Map<Long, MtcSalesbillInvoiceEntity> invoiceBillIdKeyMap, Map<Long, List<MtcSalesbillItemEntity>> billItemBillIdKeyMap, Function<Long, Integer> funTotal, Function<Long, Integer> funcMatchTotal) {
        ArrayList list = Lists.newArrayList();
        for (MtcSalesbillEntity m : billEntities) {
            MatchRelationVO matchRelationVO = this.toMatchRelationVo(m, invoiceBillIdKeyMap.get(m.getSalesbillId()), billItemBillIdKeyMap.get(m.getSalesbillId()));
            Integer total = funTotal.apply(m.getSalesbillId());
            Integer matchTotal = funcMatchTotal.apply(m.getSalesbillId());
            matchRelationVO.setItemTotal(total);
            matchRelationVO.setItemMatchStatusTotal(matchTotal);
            list.add(matchRelationVO);
        }
        return list;
    }

    @Mappings(value={@Mapping(target="id", source="invoiceEntity.id"), @Mapping(target="salesbillId", source="invoiceEntity.salesbillId"), @Mapping(target="salesbillNo", source="invoiceEntity.salesbillNo"), @Mapping(target="sellerTaxNo", source="invoiceEntity.sellerTaxNo"), @Mapping(target="sellerGroupId", source="invoiceEntity.sellerGroupId"), @Mapping(target="sellerId", source="invoiceEntity.sellerId"), @Mapping(target="sellerName", source="invoiceEntity.sellerName"), @Mapping(target="purchaserName", source="invoiceEntity.purchaserName"), @Mapping(target="purchaserTaxNo", source="invoiceEntity.purchaserTaxNo"), @Mapping(target="purchaserGroupId", source="invoiceEntity.purchaserGroupId"), @Mapping(target="purchaserId", source="invoiceEntity.purchaserId"), @Mapping(target="status", source="invoiceEntity.status"), @Mapping(target="billTaxAmount", source="m.taxAmount"), @Mapping(target="billAmountWithTax", source="m.amountWithoutTax"), @Mapping(target="billAmountWithoutTax", source="m.amountWithTax"), @Mapping(target="createTime", source="m.createTime"), @Mapping(target="billItemVOList", source="billItemEntities")})
    public MatchRelationVO toMatchRelationVo(MtcSalesbillEntity var1, MtcSalesbillInvoiceEntity var2, List<MtcSalesbillItemEntity> var3);

    default public List<BillVO> toRecommendBillList(List<MtcSalesbillEntity> entityList, Map<Long, Integer> billWeight, Map<Long, StringBuilder> billWeightRemark) {
        if (entityList == null) {
            return null;
        }
        ArrayList<BillVO> list = new ArrayList<BillVO>(entityList.size());
        for (MtcSalesbillEntity mtcSalesbillEntity : entityList) {
            list.add(this.toRecommendBill(mtcSalesbillEntity, billWeight, billWeightRemark));
        }
        this.sortBill(list);
        return list;
    }

    default public void sortBill(@MappingTarget List<BillVO> billVOList) {
        billVOList.sort((o1, o2) -> o2.getBillWeight() - o1.getBillWeight());
    }

    @Mappings(value={@Mapping(target="billWeight", expression="java(billWeight.get(entity.getSalesbillId()))"), @Mapping(target="billWeightRemark", expression="java(billWeightRemark.get(entity.getSalesbillId()).toString())")})
    public BillVO toRecommendBill(MtcSalesbillEntity var1, Map<Long, Integer> var2, Map<Long, StringBuilder> var3);

    default public List<InvoiceVO> toRecommendInvoiceList(List<MsPimInvoiceRow> rowList, Map<Long, Integer> invoiceWeight, Map<Long, StringBuilder> invoiceWeightRemark) {
        if (rowList == null) {
            return null;
        }
        ArrayList<InvoiceVO> list = new ArrayList<InvoiceVO>(rowList.size());
        for (MsPimInvoiceRow msPimInvoiceRow : rowList) {
            list.add(this.toRecommendInvoice(msPimInvoiceRow, invoiceWeight, invoiceWeightRemark));
        }
        this.sortInvoice(list);
        return list;
    }

    @AfterMapping
    default public void sortInvoice(@MappingTarget List<InvoiceVO> invoiceVOList) {
        invoiceVOList.sort((o1, o2) -> o2.getInvoiceWeight() - o1.getInvoiceWeight());
    }

    @Mappings(value={@Mapping(target="invoiceId", source="row.id"), @Mapping(target="invoiceWeight", expression="java(invoiceWeight.get(row.getId()))"), @Mapping(target="invoiceWeightRemark", expression="java(invoiceWeightRemark.get(row.getId()).toString())")})
    public InvoiceVO toRecommendInvoice(MsPimInvoiceRow var1, Map<Long, Integer> var2, Map<Long, StringBuilder> var3);

    public List<InvoiceErrorVO> toInvoiceErrorVo(List<MsPimInvoiceRow> var1);

    public List<BillErrorVO> toBillErrorVo(List<MtcSalesbillEntity> var1);

    default public InvoiceBillListErrorVO toInvoiceBillListErrorVO(List<MsPimInvoiceRow> rows, List<MtcSalesbillEntity> entities) {
        InvoiceBillListErrorVO invoiceBillListErrorVO = new InvoiceBillListErrorVO();
        List invoiceErrorVOList = this.toInvoiceErrorVo(rows);
        List billErrorVOList = new ArrayList();
        invoiceBillListErrorVO.setInvoiceErrorVOList(invoiceErrorVOList);
        if (CollectionUtils.isNotEmpty((Collection)invoiceErrorVOList)) {
            billErrorVOList = this.toBillErrorVo(entities);
        }
        invoiceBillListErrorVO.setBillErroVOList(billErrorVOList);
        return invoiceBillListErrorVO;
    }

    @Mappings(value={@Mapping(target="quantity", source="quantity"), @Mapping(target="amountWithoutTax", source="amountWithoutTax"), @Mapping(target="amountWithTax", source="amountWithTax"), @Mapping(target="taxAmount", source="taxAmount")})
    public MtcSalesbillItemEntity mapSelf(MtcSalesbillItemEntity var1, BigDecimal var2, BigDecimal var3, BigDecimal var4, BigDecimal var5);
}

