/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.mapstruct;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.match.bean.PimMatchCountBean;
import com.xforceplus.phoenix.match.bean.PimParamBean;
import com.xforceplus.phoenix.match.client.model.MsExportMatchRequest;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailDTO;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailRowDTO;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailStatDTO;
import com.xforceplus.phoenix.match.client.model.invoice.MatchInvoiceListStatDTO;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceDetailRequest;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceListRequest;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.utils.DateTools;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceDetailRow;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", imports={DateTools.class, Lists.class, MatchStatusEnum.class})
public interface PimInvoiceMapper {
    public PimParamBean msInvoiceDetailRequestToBean(MsInvoiceDetailRequest var1);

    public PimParamBean msExportMatchRequestToBean(MsExportMatchRequest var1);

    @Mapping(target="matchStatus", expression="java(null == request.getMatchStatus() ? null : Lists.newArrayList(request.getMatchStatus()))")
    public PimParamBean msInvoiceListRequestToBean(MsInvoiceListRequest var1);

    public List<InvoiceDetailRowDTO> msDetailRowToDetailRowDTO(List<MsPimInvoiceDetailRow> var1);

    @Mapping(source="id", target="invoiceId")
    public InvoiceDetailDTO rowToDetail(MsPimInvoiceRow var1);

    public InvoiceDetailStatDTO rowToDetailStat(MsPimInvoiceRow var1);

    default public List<InvoiceDetailDTO> invoiceRowToDetailDTO(List<MsPimInvoiceRow> rows, Map<Long, List<InvoiceDetailRowDTO>> invoiceDetailMap) {
        if (rows == null) {
            return null;
        }
        ArrayList<InvoiceDetailDTO> list = new ArrayList<InvoiceDetailDTO>(rows.size());
        for (MsPimInvoiceRow row : rows) {
            InvoiceDetailDTO detail = this.rowToDetail(row);
            InvoiceDetailStatDTO detailStat = this.rowToDetailStat(row);
            detail.setInvoiceDetailStat(detailStat);
            detail.setInvoiceDetailRow(invoiceDetailMap.get(row.getId()));
            list.add(detail);
        }
        return list;
    }

    public List<MatchInvoiceListStatDTO> invoiceCountToDTOList(List<Integer> var1, @Context List<PimMatchCountBean> var2);

    @Mappings(value={@Mapping(target="count", expression="java(String.valueOf(pimMatchCountBeans.stream().filter(r -> r.getMatchStatus().equals(code)).mapToInt(r -> r.getCount()).sum()))"), @Mapping(target="name", expression="java(MatchStatusEnum.getNameByValue(code))")})
    public MatchInvoiceListStatDTO invoiceCountToDTO(Integer var1, @Context List<PimMatchCountBean> var2);
}

