/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.mapstruct;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.match.bean.PimMatchCountBean;
import com.xforceplus.phoenix.match.bean.PimParamBean;
import com.xforceplus.phoenix.match.client.model.MsExportMatchRequest;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailDTO;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailRowDTO;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailStatDTO;
import com.xforceplus.phoenix.match.client.model.invoice.MatchInvoiceListStatDTO;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceDetailRequest;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceListRequest;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.PimInvoiceMapper;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceDetailRow;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PimInvoiceMapperImpl
implements PimInvoiceMapper {
    public PimParamBean msInvoiceDetailRequestToBean(MsInvoiceDetailRequest request) {
        if (request == null) {
            return null;
        }
        PimParamBean pimParamBean = new PimParamBean();
        pimParamBean.setInvoiceId(request.getInvoiceId());
        pimParamBean.setInvoiceNo(request.getInvoiceNo());
        pimParamBean.setInvoiceCode(request.getInvoiceCode());
        pimParamBean.setPurchaserName(request.getPurchaserName());
        pimParamBean.setSellerName(request.getSellerName());
        List list = request.getMatchStatus();
        if (list != null) {
            pimParamBean.setMatchStatus(new ArrayList(list));
        }
        pimParamBean.setPaperDrewDateStart(request.getPaperDrewDateStart());
        pimParamBean.setPaperDrewDateEnd(request.getPaperDrewDateEnd());
        pimParamBean.setRecogResponseTimeStart(request.getRecogResponseTimeStart());
        pimParamBean.setRecogResponseTimeEnd(request.getRecogResponseTimeEnd());
        pimParamBean.setCooperateFlag(request.getCooperateFlag());
        List list1 = request.getBussinessNo();
        if (list1 != null) {
            pimParamBean.setBussinessNo(new ArrayList(list1));
        }
        pimParamBean.setPageOrigin(request.getPageOrigin());
        List list2 = request.getSellerOrigin();
        if (list2 != null) {
            pimParamBean.setSellerOrigin(new ArrayList(list2));
        }
        return pimParamBean;
    }

    public PimParamBean msExportMatchRequestToBean(MsExportMatchRequest request) {
        if (request == null) {
            return null;
        }
        PimParamBean pimParamBean = new PimParamBean();
        pimParamBean.setInvoiceNo(request.getInvoiceNo());
        pimParamBean.setInvoiceCode(request.getInvoiceCode());
        pimParamBean.setPurchaserName(request.getPurchaserName());
        pimParamBean.setSellerName(request.getSellerName());
        pimParamBean.setRecogResponseTimeStart(request.getRecogResponseTimeStart());
        pimParamBean.setRecogResponseTimeEnd(request.getRecogResponseTimeEnd());
        pimParamBean.setCooperateFlag(request.getCooperateFlag());
        List list = request.getSellerOrigin();
        if (list != null) {
            pimParamBean.setSellerOrigin(new ArrayList(list));
        }
        return pimParamBean;
    }

    public PimParamBean msInvoiceListRequestToBean(MsInvoiceListRequest request) {
        if (request == null) {
            return null;
        }
        PimParamBean pimParamBean = new PimParamBean();
        pimParamBean.setInvoiceNo(request.getInvoiceNo());
        pimParamBean.setInvoiceCode(request.getInvoiceCode());
        pimParamBean.setPurchaserName(request.getPurchaserName());
        pimParamBean.setSellerName(request.getSellerName());
        pimParamBean.setPaperDrewDateStart(request.getPaperDrewDateStart());
        pimParamBean.setPaperDrewDateEnd(request.getPaperDrewDateEnd());
        pimParamBean.setRecogResponseTimeStart(request.getRecogResponseTimeStart());
        pimParamBean.setRecogResponseTimeEnd(request.getRecogResponseTimeEnd());
        pimParamBean.setCooperateFlag(request.getCooperateFlag());
        List list = request.getSellerOrigin();
        if (list != null) {
            pimParamBean.setSellerOrigin(new ArrayList(list));
        }
        pimParamBean.setMatchStatus(null == request.getMatchStatus() ? null : Lists.newArrayList((Object[])new Integer[]{request.getMatchStatus()}));
        return pimParamBean;
    }

    public List<InvoiceDetailRowDTO> msDetailRowToDetailRowDTO(List<MsPimInvoiceDetailRow> detailRows) {
        if (detailRows == null) {
            return null;
        }
        ArrayList<InvoiceDetailRowDTO> list = new ArrayList<InvoiceDetailRowDTO>(detailRows.size());
        for (MsPimInvoiceDetailRow msPimInvoiceDetailRow : detailRows) {
            list.add(this.msPimInvoiceDetailRowToInvoiceDetailRowDTO(msPimInvoiceDetailRow));
        }
        return list;
    }

    public InvoiceDetailDTO rowToDetail(MsPimInvoiceRow row) {
        if (row == null) {
            return null;
        }
        InvoiceDetailDTO invoiceDetailDTO = new InvoiceDetailDTO();
        invoiceDetailDTO.setInvoiceId(row.getId());
        invoiceDetailDTO.setId(row.getId());
        invoiceDetailDTO.setStatus(row.getStatus());
        invoiceDetailDTO.setBussinessId(row.getBussinessId());
        invoiceDetailDTO.setBussinessNo(row.getBussinessNo());
        invoiceDetailDTO.setInvoiceType(row.getInvoiceType());
        invoiceDetailDTO.setInvoiceCode(row.getInvoiceCode());
        invoiceDetailDTO.setInvoiceNo(row.getInvoiceNo());
        invoiceDetailDTO.setPaperDrewDate(row.getPaperDrewDate());
        invoiceDetailDTO.setCheckCode(row.getCheckCode());
        invoiceDetailDTO.setMachineCode(row.getMachineCode());
        invoiceDetailDTO.setPurchaserName(row.getPurchaserName());
        invoiceDetailDTO.setPurchaserTaxNo(row.getPurchaserTaxNo());
        invoiceDetailDTO.setPurchaserAddrTel(row.getPurchaserAddrTel());
        invoiceDetailDTO.setPurchaserBankNameAccount(row.getPurchaserBankNameAccount());
        invoiceDetailDTO.setCipherText(row.getCipherText());
        invoiceDetailDTO.setAmountWithTax(row.getAmountWithTax());
        invoiceDetailDTO.setAmountWithoutTax(row.getAmountWithoutTax());
        invoiceDetailDTO.setTaxAmount(row.getTaxAmount());
        invoiceDetailDTO.setMatchAmount(row.getMatchAmount());
        invoiceDetailDTO.setSellerName(row.getSellerName());
        invoiceDetailDTO.setSellerTaxNo(row.getSellerTaxNo());
        invoiceDetailDTO.setSellerAddrTel(row.getSellerAddrTel());
        invoiceDetailDTO.setSellerBankNameAccount(row.getSellerBankNameAccount());
        invoiceDetailDTO.setRemark(row.getRemark());
        invoiceDetailDTO.setSellerTel(row.getSellerTel());
        invoiceDetailDTO.setSellerBankAccount(row.getSellerBankAccount());
        invoiceDetailDTO.setSellerAddress(row.getSellerAddress());
        invoiceDetailDTO.setSellerBankName(row.getSellerBankName());
        invoiceDetailDTO.setTaxRate(row.getTaxRate());
        invoiceDetailDTO.setSpecialInvoiceFlag(row.getSpecialInvoiceFlag());
        invoiceDetailDTO.setSellerOrigin(row.getSellerOrigin());
        return invoiceDetailDTO;
    }

    public InvoiceDetailStatDTO rowToDetailStat(MsPimInvoiceRow row) {
        if (row == null) {
            return null;
        }
        InvoiceDetailStatDTO invoiceDetailStatDTO = new InvoiceDetailStatDTO();
        invoiceDetailStatDTO.setSellerSyncStatus(row.getSellerSyncStatus());
        invoiceDetailStatDTO.setRecogStatus(row.getRecogStatus());
        invoiceDetailStatDTO.setRecogResponseTime(row.getRecogResponseTime());
        invoiceDetailStatDTO.setVeriStatus(row.getVeriStatus());
        invoiceDetailStatDTO.setVeriResponseTime(row.getVeriResponseTime());
        invoiceDetailStatDTO.setMatchStatus(row.getMatchStatus());
        invoiceDetailStatDTO.setMatchTime(row.getMatchTime());
        invoiceDetailStatDTO.setAuthStatus(row.getAuthStatus());
        invoiceDetailStatDTO.setAuthResponseTime(row.getAuthResponseTime());
        invoiceDetailStatDTO.setAuthSyncStatus(row.getAuthSyncStatus());
        invoiceDetailStatDTO.setChargeUpStatus(row.getChargeUpStatus());
        invoiceDetailStatDTO.setSaleConfirmStatus(row.getSaleConfirmStatus());
        invoiceDetailStatDTO.setPaymentStatus(row.getPaymentStatus());
        invoiceDetailStatDTO.setFreezeStatus(row.getFreezeStatus());
        invoiceDetailStatDTO.setLoseStatus(row.getLoseStatus());
        invoiceDetailStatDTO.setComplianceStatus(row.getComplianceStatus());
        invoiceDetailStatDTO.setRetreatStatus(row.getRetreatStatus());
        return invoiceDetailStatDTO;
    }

    public List<MatchInvoiceListStatDTO> invoiceCountToDTOList(List<Integer> matchStatus, List<PimMatchCountBean> pimMatchCountBeans) {
        if (matchStatus == null) {
            return null;
        }
        ArrayList<MatchInvoiceListStatDTO> list = new ArrayList<MatchInvoiceListStatDTO>(matchStatus.size());
        for (Integer integer : matchStatus) {
            list.add(this.invoiceCountToDTO(integer, pimMatchCountBeans));
        }
        return list;
    }

    public MatchInvoiceListStatDTO invoiceCountToDTO(Integer code, List<PimMatchCountBean> pimMatchCountBeans) {
        if (code == null) {
            return null;
        }
        MatchInvoiceListStatDTO matchInvoiceListStatDTO = new MatchInvoiceListStatDTO();
        matchInvoiceListStatDTO.setCode(String.valueOf(code));
        matchInvoiceListStatDTO.setCount(String.valueOf(pimMatchCountBeans.stream().filter(r -> r.getMatchStatus().equals(code)).mapToInt(r -> r.getCount()).sum()));
        matchInvoiceListStatDTO.setName(MatchStatusEnum.getNameByValue((Integer)code));
        return matchInvoiceListStatDTO;
    }

    protected InvoiceDetailRowDTO msPimInvoiceDetailRowToInvoiceDetailRowDTO(MsPimInvoiceDetailRow msPimInvoiceDetailRow) {
        if (msPimInvoiceDetailRow == null) {
            return null;
        }
        InvoiceDetailRowDTO invoiceDetailRowDTO = new InvoiceDetailRowDTO();
        invoiceDetailRowDTO.setId(msPimInvoiceDetailRow.getId());
        invoiceDetailRowDTO.setInvoiceId(msPimInvoiceDetailRow.getInvoiceId());
        invoiceDetailRowDTO.setCargoName(msPimInvoiceDetailRow.getCargoName());
        invoiceDetailRowDTO.setItemSpec(msPimInvoiceDetailRow.getItemSpec());
        invoiceDetailRowDTO.setQuantityUnit(msPimInvoiceDetailRow.getQuantityUnit());
        invoiceDetailRowDTO.setUnitPrice(msPimInvoiceDetailRow.getUnitPrice());
        invoiceDetailRowDTO.setQuantity(msPimInvoiceDetailRow.getQuantity());
        invoiceDetailRowDTO.setAmountWithTax(msPimInvoiceDetailRow.getAmountWithTax());
        invoiceDetailRowDTO.setTaxRate(msPimInvoiceDetailRow.getTaxRate());
        invoiceDetailRowDTO.setTaxAmount(msPimInvoiceDetailRow.getTaxAmount());
        invoiceDetailRowDTO.setAmountWithoutTax(msPimInvoiceDetailRow.getAmountWithoutTax());
        return invoiceDetailRowDTO;
    }
}

