/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.common.utils;

import com.xforceplus.purchaser.common.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTools {
    public static final String DATE_FORMAT_FULL = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_SHORT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_COMPACT = "yyyyMMdd";
    public static final String DATE_FORMAT_COMPACTFULL = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_FULL_MSEL = "yyyyMMddHHmmssSSSS";
    public static final String DATE_YEAR_MONTH = "yyyyMM";
    public static final String DATE_FORMAT_FULL_MSE = "yyyyMMddHHmmssSSS";
    public static final String REGEX = "((19|20)[0-9]{2})-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])";

    public static boolean match(String text, String regex) {
        if (StringUtils.isBlank((CharSequence)text) || StringUtils.isBlank((CharSequence)regex)) {
            return false;
        }
        return Pattern.compile(regex).matcher(text).matches();
    }

    public static String toDateString19(String timestamp) {
        return StringUtils.isEmpty((CharSequence)timestamp) ? null : DateUtils.toDateTimeStr19((Date)new Date(Long.parseLong(timestamp)));
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now();
    }

    public static String getCurDateTime(String format) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        String dataTime = now.format(dateTimeFormatter);
        return dataTime;
    }

    public static String getCurDateTimeFull() {
        return DateTools.getCurDateTime((String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurDateTime1() {
        return DateTools.getCurDateTime((String)"yyyyMMddHHmmss");
    }

    public static String getCurDateYYYYMM() {
        return DateTools.getCurDateTime((String)"yyyyMM");
    }

    public static String getCurDateYYYYMMDD() {
        return DateTools.getCurDateTime((String)"yyyyMMdd");
    }

    public static boolean isCurrentDay(String strDate) {
        boolean bRet = false;
        LocalDate strLocalDate = LocalDate.parse(strDate);
        if (LocalDate.now().getYear() == strLocalDate.getYear()) {
            MonthDay monthDay = MonthDay.from(strLocalDate);
            MonthDay today = MonthDay.from(LocalDate.now());
            return monthDay.equals(today);
        }
        return false;
    }

    public static String getAfterDateTime(int hour, String format) {
        LocalTime localTime = LocalTime.now().plusHours(hour);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        String dataTime = localTime.format(dateTimeFormatter);
        return dataTime;
    }

    public static String getTimeStamp() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSS");
        return now.format(dateTimeFormatter);
    }

    public static String parseDateToString(Date thedate, String format) {
        if (thedate != null) {
            Instant instant = thedate.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            return localDateTime.format(dateTimeFormatter);
        }
        return null;
    }

    public static String parseDateToString(Date thedate) {
        return DateTools.parseDateToString((Date)thedate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseStringToDate(String thedate, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dd1 = null;
        try {
            dd1 = sdf.parse(thedate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dd1;
    }

    public static String changeFormatDateString(String format1, String format2, String strDate) {
        if (strDate == null) {
            return "";
        }
        if (strDate.length() >= format1.length() && format1.length() >= format2.length()) {
            return DateTools.parseDateToString((Date)DateTools.parseStringToDate((String)strDate, (String)format1), (String)format2);
        }
        return strDate;
    }

    public static String beforeNDaysDate(String format, int day) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        if (day > 0) {
            return LocalDateTime.now().minusDays(day).format(dateTimeFormatter);
        }
        return null;
    }

    public static String afterNMonthDate(String theDate, int month, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusMonths(month).format(dateTimeFormatter);
    }

    public static String afterNDaysDate(String theDate, Integer nDayNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusDays(nDayNum.intValue()).format(dateTimeFormatter);
    }

    public static String afterNHoursDate(String theDate, Integer nHourNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusHours(nHourNum.intValue()).format(dateTimeFormatter);
    }

    public static String afterNMinsDate(String theDate, Integer nMinNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusMinutes(nMinNum.intValue()).format(dateTimeFormatter);
    }

    public static String afterNSecondsDate(String theDate, Integer nSecNum, String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(theDate, dateTimeFormatter).plusSeconds(nSecNum.intValue()).format(dateTimeFormatter);
    }

    public static boolean isBefore(String strdat1, String strdat2, String format) {
        try {
            Date dat1 = DateTools.parseStringToDate((String)strdat1, (String)format);
            Date dat2 = DateTools.parseStringToDate((String)strdat2, (String)format);
            return dat1.before(dat2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long isBefore_int(String strdat1, String strdat2, String format) {
        long result = 0L;
        try {
            Date dat1 = DateTools.parseStringToDate((String)strdat1, (String)format);
            Date dat2 = DateTools.parseStringToDate((String)strdat2, (String)format);
            return dat2.getTime() - dat1.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String changeTime(int sec) {
        String temp = "";
        temp = sec < 60 ? "" + sec + "\u79d2" : (sec < 3600 ? "" + sec / 60 + "\u5206" + sec % 60 + "\u79d2" : "" + sec / 3600 + "\u5c0f\u65f6" + sec % 3600 / 60 + "\u5206" + sec % 60 + "\u79d2");
        return temp;
    }

    public static int getSubDays(String end, String start) {
        LocalDate startDate = LocalDate.parse(start);
        LocalDate endDate = LocalDate.parse(end);
        Long between = ChronoUnit.DAYS.between(startDate, endDate);
        return between.intValue();
    }

    public static String getTimeDiff(Date time1, Date time2) throws Exception {
        long s;
        long min;
        long hour;
        long l = time1.getTime() - time2.getTime();
        String returnStr = "";
        long day = l / 86400000L;
        if (day > 0L) {
            returnStr = returnStr + day + "\u5929";
        }
        if ((hour = l / 3600000L - day * 24L) > 0L) {
            returnStr = returnStr + hour + "\u5c0f\u65f6";
        }
        if ((min = l / 60000L - day * 24L * 60L - hour * 60L) > 0L) {
            returnStr = returnStr + min + "\u5206";
        }
        if ((s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L) > 0L) {
            returnStr = returnStr + s + "\u79d2";
        }
        return returnStr;
    }
}

