/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.config;

import com.xforceplus.phoenix.cache.util.RedisUtil;
import com.xforceplus.phoenix.match.client.LoginApi;
import com.xforceplus.phoenix.match.client.MessageMiddleClient;
import com.xforceplus.phoenix.match.common.feign.AccessTokenInterceptor;
import com.xforceplus.phoenix.match.common.feign.ApiClient;
import com.xforceplus.phoenix.match.config.OpenapiSettings;
import feign.Request;
import feign.RequestInterceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApiConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApiConfiguration.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OkHttpClient okHttpClient;
    @Autowired
    private OpenapiSettings openapiSettings;

    @Bean
    public LoginApi accessClient() {
        return (LoginApi)new ApiClient(new Request.Options(), this.okHttpClient).basePath(this.openapiSettings.getMiddleUrl()).buildClient(LoginApi.class);
    }

    @Bean
    public MessageMiddleClient messageMiddleClient() {
        return (MessageMiddleClient)new ApiClient(new Request.Options(), this.okHttpClient).basePath(this.openapiSettings.getMiddleUrl()).requestInterceptor((RequestInterceptor)new AccessTokenInterceptor(this.accessClient(), this.openapiSettings.getMiddleClientId(), this.openapiSettings.getMiddleSecret(), this.redisUtil, "", this.openapiSettings.getMiddleUrl(), "USERCENTER")).buildClient(MessageMiddleClient.class);
    }
}

