/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.config;

import com.xforceplus.phoenix.match.client.response.Response;
import com.xforceplus.phoenix.match.exception.ApiError;
import com.xforceplus.phoenix.match.exception.MatchBizException;
import com.xforceplus.phoenix.match.exception.MatchParamException;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

public class ExceptionHandlerAdvice
extends ResponseEntityExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String error = ex.getParameterName() + " parameter is missing";
        return this.buildResponseEntity(new ApiError(HttpStatus.BAD_REQUEST, error, (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    protected ResponseEntity<Object> handleMissingPathVariable(MissingPathVariableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String error = ex.getVariableName() + " parameter is missing";
        return this.buildResponseEntity(new ApiError(HttpStatus.BAD_REQUEST, error, (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String message = ex.getMessage();
        return this.buildResponseEntity(new ApiError(HttpStatus.METHOD_NOT_ALLOWED, message, (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(ex.getContentType());
        builder.append(" media type is not supported. Supported media types are ");
        ex.getSupportedMediaTypes().forEach(t -> builder.append(t).append(", "));
        return this.buildResponseEntity(new ApiError(HttpStatus.UNSUPPORTED_MEDIA_TYPE, builder.substring(0, builder.length() - 2), (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage("Validation error");
        apiError.addValidationErrors(ex.getBindingResult().getFieldErrors());
        apiError.addValidationError(ex.getBindingResult().getGlobalErrors());
        apiError.setCode(Response.RESULT_FAIL_PARAM);
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setCode(Response.RESULT_FAIL_PARAM);
        apiError.setMessage("Validation error");
        apiError.addValidationErrors(ex.getConstraintViolations());
        return this.buildResponseEntity(apiError);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String error = "Malformed JSON request";
        return this.buildResponseEntity(new ApiError(HttpStatus.BAD_REQUEST, "Malformed JSON request", (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String error = "Error writing JSON output";
        return this.buildResponseEntity(new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, "Error writing JSON output", (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    protected ResponseEntity<Object> handleServletRequestBindingException(ServletRequestBindingException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String error = ex.getMessage();
        return this.buildResponseEntity(new ApiError(HttpStatus.BAD_REQUEST, error, (Throwable)ex, Response.RESULT_FAIL_PARAM));
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException ex, WebRequest request) {
        this.logger.error("dataBase error!", (Throwable)ex);
        if (ex.getCause() instanceof ConstraintViolationException) {
            return this.buildResponseEntity(new ApiError(HttpStatus.CONFLICT, "Database error", ex.getCause(), Response.RESULT_FAIL));
        }
        return this.buildResponseEntity(new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)ex));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(String.format("The parameter '%s' of value '%s' could not be converted to type '%s'", ex.getName(), ex.getValue(), ex.getRequiredType().getSimpleName()));
        apiError.setDebugMessage(ex.getMessage());
        apiError.setCode(Response.RESULT_FAIL_PARAM);
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handlerGlobalException(Exception ex) {
        this.logger.error("request handler fail!", (Throwable)ex);
        ApiError apiError = new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)ex);
        apiError.setMessage(ex.getMessage());
        apiError.setCode(Response.RESULT_FAIL);
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={MatchParamException.class})
    protected ResponseEntity<Object> handlerMatchParamException(MatchParamException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        apiError.setCode(Response.RESULT_FAIL);
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={MatchBizException.class})
    protected ResponseEntity<Object> handlerMatchBizException(MatchBizException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        apiError.setCode(Response.RESULT_FAIL);
        return this.buildResponseEntity(apiError);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            request.setAttribute("javax.servlet.error.exception", (Object)ex, 0);
        }
        ApiError apiError = new ApiError(status, (Throwable)ex);
        apiError.setCode(Response.RESULT_FAIL);
        apiError.setMessage(ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    private ResponseEntity<Object> buildResponseEntity(ApiError apiError) {
        Response baseResponse = new Response();
        baseResponse.setCode(apiError.getCode().intValue());
        baseResponse.setMessage(apiError.getMessage());
        baseResponse.setResult((Object)apiError.getSubErrors());
        return new ResponseEntity((Object)baseResponse, apiError.getStatus());
    }
}

