/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.config;

import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.SensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.consumer.BatchConsumer;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.DebugConsumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SensorsConfig {
    @Value(value="${sensor.env}")
    private String env;
    @Value(value="${sensor.serverUrl}")
    private String serverUrl;
    @Value(value="${sensor.bulkSize:50}")
    private int bulkSize;
    @Value(value="${sensor.timeoutSec:3}")
    private int timeoutSec;
    @Value(value="${sensor.maxCacheSize:0}")
    private int maxCacheSize;
    @Value(value="${sensor.throwException:false}")
    private boolean throwException;
    @Value(value="${sensor.isDebug}")
    private boolean isDebug;

    @Bean(destroyMethod="shutdown")
    public ISensorsAnalytics init() throws InvalidArgumentException {
        Object consumer = this.isDebug ? new DebugConsumer(this.serverUrl, true) : new BatchConsumer(this.serverUrl, this.bulkSize, this.timeoutSec, this.maxCacheSize, this.throwException);
        SensorsAnalytics sa = new SensorsAnalytics((Consumer)consumer);
        SuperPropertiesRecord propertiesRecord = SuperPropertiesRecord.builder().addProperty("product_line", "\u8fdb\u9879\u4ea7\u54c1\u7ebf").addProperty("platform_type", "web").addProperty("product_name", "\u914d\u5355\u670d\u52a1").addProperty("product_env", this.env).build();
        sa.registerSuperProperties(propertiesRecord);
        return sa;
    }
}

