/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.rabbitmq;

import com.xforceplus.phoenix.match.bean.BatchMatchInvoicesBean;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchMatchInvoicesListener {
    private static final Logger log = LoggerFactory.getLogger(BatchMatchInvoicesListener.class);
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;
    @Autowired
    RabbitmqService rabbitmqService;

    @RabbitListener(bindings={@QueueBinding(exchange=@Exchange(value="topicExchange", type="topic"), key={"openapi.batch.match.invoices.queue"}, value=@Queue(value="openapi.batch.match.invoices.queue"))}, concurrency="2", autoStartup="true", errorHandler="mqErrorHandler")
    @RabbitHandler
    public void batchMatchInvoicesHandler(Message message) {
        String msg = new String(message.getBody());
        log.info("batchMatchInvoicesHandler, msg:{}", (Object)msg);
        BatchMatchInvoicesBean batchMatchInvoicesBean = (BatchMatchInvoicesBean)JsonUtils.writeJsonToObject((String)msg, BatchMatchInvoicesBean.class);
        MtcSalesbillExample example = new MtcSalesbillExample();
        example.createCriteria().andSalesbillNoEqualTo(batchMatchInvoicesBean.getBusinessNo()).andPurchaserGroupIdEqualTo(batchMatchInvoicesBean.getGroupId()).andStatusEqualTo(Integer.valueOf(1));
        MtcSalesbillEntity entity = new MtcSalesbillEntity();
        entity.setExt1(batchMatchInvoicesBean.getInvoicesStr());
        try {
            this.mtcSalesbillDao.updateByExampleSelective(entity, example);
        }
        catch (Exception e) {
            log.error("batchMatchInvoicesHandler\u66f4\u65b0\u6570\u636e\u5e93\u5f02\u5e38,{}", (Throwable)e);
        }
        MtcSalesbillEntity entityU = this.mtcSalesbillDao.selectOneByExample(example);
        String sendMsg = entityU.getSalesbillId().toString();
        log.info("\u89e6\u53d1\u4e1a\u52a1\u5355\u4e0a\u4f20\u53d1\u7968\u53f7\u7801\u81ea\u52a8\u914d\u5355\u629b\u9001\u961f\u5217\uff0csendMsg:{}", (Object)sendMsg);
        this.rabbitmqService.sendByTopicExchange("match.from.salesbill.queue", (Object)sendMsg);
    }
}

