/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.rabbitmq;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.match.client.PimInvoiceQueryClient;
import com.xforceplus.phoenix.match.client.request.MatchRequest;
import com.xforceplus.phoenix.match.client.response.Response;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.match.service.NewMatchService;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceParam;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceParamGroup;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.client.model.config.ConfigItemCodeEnum;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionAffirmBean;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionAutoBean;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MatchFromSalesbillListener {
    private static final Logger log = LoggerFactory.getLogger(MatchFromSalesbillListener.class);
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;
    @Autowired
    PimInvoiceQueryClient pimInvoiceQueryClient;
    @Autowired
    NewMatchService newMatchService;
    @Autowired
    DependService dependService;

    @RabbitListener(bindings={@QueueBinding(exchange=@Exchange(value="topicExchange", type="topic"), key={"match.from.salesbill.queue"}, value=@Queue(value="match.from.salesbill.queue"))}, concurrency="1", autoStartup="true", errorHandler="mqErrorHandler")
    @RabbitHandler
    public void matchSalesbillAndInvoices(Message message) {
        String msg = new String(message.getBody());
        log.info("matchSalesbillAndInvoices, salesbillId:{}", (Object)msg);
        Long salesbillId = Long.parseLong(msg);
        MtcSalesbillEntity entity = this.mtcSalesbillDao.selectByPrimaryKey(salesbillId);
        log.info("\u4e1a\u52a1\u5355\u6765\u6e90\u81ea\u52a8\u914d\u5355:{}", (Object)JsonUtils.writeObjectToJson((Object)entity));
        if (entity != null && 0 == entity.getCooperateFlag() && !MatchStatusEnum.MATCH_END.getValue().toString().equals(entity.getMatchStatus())) {
            String invoiceNos = entity.getExt1();
            if (!StringUtils.isNotEmpty((CharSequence)invoiceNos)) {
                return;
            }
            invoiceNos = invoiceNos.replace(",", "#");
            boolean isOpenAuto = this.isOpenAutoMatch(entity);
            if (!isOpenAuto) {
                return;
            }
            boolean needAffirm = this.isNeedAffirm(entity);
            MsPimInvoiceGetPageRequest request = new MsPimInvoiceGetPageRequest();
            request.setPageIndex(Integer.valueOf(1));
            request.setPageRowCount(Integer.valueOf(100));
            request.setOrgIds((List)Lists.newArrayList((Object[])new Long[]{entity.getSysOrgId()}));
            ArrayList<MsPimInvoiceParamGroup> paramGroups = new ArrayList<MsPimInvoiceParamGroup>();
            MsPimInvoiceParamGroup paramGroup = new MsPimInvoiceParamGroup();
            ArrayList<MsPimInvoiceParam> params = new ArrayList<MsPimInvoiceParam>();
            params.add(this.setClientParam("purchaserCompanyId", "eq", entity.getPurchaserId().toString()));
            params.add(this.setClientParam("sellerTaxNo", "eq", entity.getSellerTaxNo()));
            params.add(this.setClientParam("invoiceNo", "in", invoiceNos));
            params.add(this.setClientParam("status", "eq", "1"));
            paramGroup.setParams(params);
            paramGroups.add(paramGroup);
            request.setParamGroups(paramGroups);
            MsPimInvoiceGetPageResponse getPageResponse = this.pimInvoiceQueryClient.getInvoiceRequest(request);
            log.info("\u83b7\u53d6\u4e1a\u52a1\u5355\u5907\u6ce8\u53d1\u7968\u96c6\u5408\uff0ctotal\uff1a{}", (Object)getPageResponse.getResult().size());
            if (getPageResponse.getCode() == 1 && !CommonUtils.isEmpty((List)getPageResponse.getResult())) {
                List invoiceIds = getPageResponse.getResult().stream().map(r -> r.getId()).collect(Collectors.toList());
                MatchRequest matchRequest = new MatchRequest();
                matchRequest.setAbleConfirm(Boolean.valueOf(needAffirm));
                matchRequest.setInvoiceIds(invoiceIds);
                matchRequest.setSalesBillIds((List)Lists.newArrayList((Object[])new Long[]{salesbillId}));
                matchRequest.setMatchType(Integer.valueOf(0));
                matchRequest.setSysOrgId(entity.getSysOrgId());
                Response response = this.newMatchService.createMatch(matchRequest);
                log.info("matchSalesbillAndInvoices\u81ea\u52a8\u914d\u5355\u7ed3\u679c:{}", (Object)response);
            }
        }
    }

    public boolean isOpenAutoMatch(MtcSalesbillEntity entity) {
        String val = this.dependService.getConfigItem(entity.getPurchaserGroupId(), entity.getPurchaserId(), ConfigItemCodeEnum.MATCH_CONDITION_AUTO);
        MatchConditionAutoBean matchBean = (MatchConditionAutoBean)JsonUtils.writeJsonToObject((String)val, MatchConditionAutoBean.class);
        List matchList = matchBean.getMatchConditionAutoList().stream().filter(c -> MatchConditionAutoBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        log.info("isOpenAutoMatch \u53d1\u7968id:{},\u53d1\u7968\u5bf9\u8c61:{},\u8fd4\u56de\u7ed3\u679c:{}", new Object[]{entity.getId(), JsonUtils.writeObjectToJson((Object)entity), JsonUtils.writeObjectToJson(matchList)});
        if (CollectionUtils.isEmpty(matchList)) {
            return false;
        }
        return matchList.stream().anyMatch(info -> info.getCondition().equals((Object)MatchConditionAutoBean.ConditionEnum.C01));
    }

    public boolean isNeedAffirm(MtcSalesbillEntity entity) {
        String val = this.dependService.getConfigItem(entity.getPurchaserGroupId(), entity.getPurchaserId(), ConfigItemCodeEnum.MATCH_CONDITION_AFFIRM);
        MatchConditionAffirmBean matchBean = (MatchConditionAffirmBean)JsonUtils.writeJsonToObject((String)val, MatchConditionAffirmBean.class);
        List matchList = matchBean.getMatchConditionAffirmList().stream().filter(c -> MatchConditionAffirmBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        log.info("isNeedAffirm \u53d1\u7968id:{},\u53d1\u7968\u5bf9\u8c61:{},\u8fd4\u56de\u7ed3\u679c:{}", new Object[]{entity.getId(), JsonUtils.writeObjectToJson((Object)entity), JsonUtils.writeObjectToJson(matchList)});
        if (CollectionUtils.isEmpty(matchList)) {
            return false;
        }
        return matchList.stream().anyMatch(info -> info.getCondition().equals((Object)MatchConditionAffirmBean.ConditionEnum.C02));
    }

    private MsPimInvoiceParam setClientParam(String key, String condition, String value) {
        MsPimInvoiceParam clientParam = new MsPimInvoiceParam();
        clientParam.setParamKey(key);
        clientParam.setParamCondition(condition);
        clientParam.setParamValue(value);
        return clientParam;
    }
}

