/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.rabbitmq;

import com.xforceplus.phoenix.match.client.request.CancelMatchRequest;
import com.xforceplus.phoenix.match.client.request.MatchRequest;
import com.xforceplus.phoenix.match.client.response.Response;
import com.xforceplus.phoenix.match.controller.NewMatchController;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatchInvoiceListener {
    private static final Logger log = LoggerFactory.getLogger(MatchInvoiceListener.class);
    @Autowired
    NewMatchController newMatchController;

    @RabbitListener(bindings={@QueueBinding(exchange=@Exchange(value="topicExchange", type="topic"), key={"match.bill.invoice.queue"}, value=@Queue(value="match.bill.invoice.queue"))}, concurrency="1", autoStartup="true", errorHandler="mqErrorHandler")
    @RabbitHandler
    public void getMatchBillDataListener(Message message) {
        String msg = new String(message.getBody());
        Map headers = message.getMessageProperties().getHeaders();
        String opType = headers.get("opType").toString();
        log.info("\u8bf7\u6c42\u914d\u5355MQ,\u8bf7\u6c42\u5165\u53c2\uff1a{},\u64cd\u4f5c\u7c7b\u578b:{}", (Object)msg, (Object)opType);
        try {
            if ("createMatch".equals(opType)) {
                MatchRequest matchRequest = (MatchRequest)JsonUtils.writeJsonToObject((String)msg, MatchRequest.class);
                Response response = this.newMatchController.createMatch(matchRequest);
                log.info("\u8bf7\u6c42\u914d\u5355MQ, \u89e6\u53d1\u914d\u5355id:{}, code:{}, message:{}", new Object[]{matchRequest.getInvoiceIds(), response.getCode(), response.getMessage()});
            } else if ("cancelMatch".equals(opType)) {
                CancelMatchRequest cancelMatchRequest = (CancelMatchRequest)JsonUtils.writeJsonToObject((String)msg, CancelMatchRequest.class);
                Response response = this.newMatchController.cancelMatch(cancelMatchRequest);
                log.info("\u8bf7\u6c42\u914d\u5355MQ, \u89e6\u53d1\u53d6\u6d88\u914d\u5355id:{}, code:{}, message:{}", new Object[]{cancelMatchRequest.getIds(), response.getCode(), response.getMessage()});
            } else {
                log.warn("\u672a\u77e5\u914d\u5355\u64cd\u4f5c\u7c7b\u578b\uff0c{}", (Object)msg);
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u914d\u5355MQ, \u89e6\u53d1\u914d\u5355\u5f02\u5e38", (Throwable)e);
        }
    }
}

