/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.rabbitmq;

import com.xforceplus.phoenix.match.bean.SyncSalesBillDataBean;
import com.xforceplus.phoenix.match.bean.SyncSalesBillItemDataBean;
import com.xforceplus.phoenix.match.common.mapstruct.NewMatchMapper;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillItemDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.tools.util.NullableUtil;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillDataSyncListener {
    private static final Logger logger = LoggerFactory.getLogger(SalesBillDataSyncListener.class);
    @Autowired
    private MtcSalesbillDao mtcSalesbillDao;
    @Autowired
    private MtcSalesbillItemDao mtcSalesbillItemDao;
    @Autowired
    private NewMatchMapper newMatchMapper;
    @Autowired
    RabbitmqService rabbitmqService;
    private static final String BUSINESS_BILLTYPE = "AP";
    private static final String ORD_SALESBILL = "ord_salesbill";
    private static final String ORD_SALESBILL_ITEM = "ord_salesbill_item";

    @RabbitListener(queuesToDeclare={@Queue(value="match.bill.data.sync.listener.queue")}, concurrency="1", autoStartup="true", errorHandler="mqErrorHandler")
    @RabbitHandler
    public void getMatchBillDataListener(Message message) {
        String msg = new String(message.getBody());
        try {
            List resultInfo = JsonUtils.writeJsonToListObject((String)msg, Map.class);
            if (CollectionUtils.isEmpty((Collection)resultInfo)) {
                return;
            }
            resultInfo.forEach(x -> {
                if (ORD_SALESBILL.equals(x.get("tableName"))) {
                    SyncSalesBillDataBean syncSalesBillDataBean = (SyncSalesBillDataBean)JsonUtils.writeJsonToObject((String)x.get("content").toString(), SyncSalesBillDataBean.class);
                    if (!BUSINESS_BILLTYPE.equals(syncSalesBillDataBean.getBusinessBillType())) {
                        return;
                    }
                    logger.info("\u63a5\u6536\u9500\u9879\u63a8\u9001AP\u5355\u636e\u4e3b\u4fe1\u606f:{}", (Object)syncSalesBillDataBean);
                    MtcSalesbillEntity mtcSalesbillEntity = this.newMatchMapper.syncSalesToEntity(syncSalesBillDataBean);
                    Long salesbillId = syncSalesBillDataBean.getSalesbillId();
                    MtcSalesbillEntity entity = this.mtcSalesbillDao.selectByPrimaryKey(salesbillId);
                    if (entity != null) {
                        this.mtcSalesbillDao.updateByPrimaryKeySelective(mtcSalesbillEntity);
                    } else {
                        this.mtcSalesbillDao.insertSelective(mtcSalesbillEntity);
                        this.rabbitmqService.sendByTopicExchange("match.from.salesbill.queue", (Object)NullableUtil.toStringValue((Object)salesbillId, (String)"0"));
                    }
                } else if (ORD_SALESBILL_ITEM.equals(x.get("tableName"))) {
                    SyncSalesBillItemDataBean syncSalesBillItemDataBean = (SyncSalesBillItemDataBean)JsonUtils.writeJsonToObject((String)x.get("content").toString(), SyncSalesBillItemDataBean.class);
                    if (!BUSINESS_BILLTYPE.equals(syncSalesBillItemDataBean.getBusinessBillType())) {
                        return;
                    }
                    logger.info("\u63a5\u6536\u9500\u9879\u63a8\u9001AP\u5355\u636e\u660e\u7ec6\u4fe1\u606f:{}", (Object)syncSalesBillItemDataBean);
                    MtcSalesbillItemEntity mtcSalesbillItemEntity = this.newMatchMapper.syncSalesItemToEntity(syncSalesBillItemDataBean);
                    MtcSalesbillItemEntity entity = this.mtcSalesbillItemDao.selectByPrimaryKey(syncSalesBillItemDataBean.getSalesbillItemId());
                    if (entity != null) {
                        this.mtcSalesbillItemDao.updateByPrimaryKeySelective(mtcSalesbillItemEntity);
                    } else {
                        this.mtcSalesbillItemDao.insertSelective(mtcSalesbillItemEntity);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("getMatchBillDataListener,exception", (Throwable)e);
        }
    }
}

