/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.match.bean.BillInvoiceGroupBean;
import com.xforceplus.phoenix.match.client.PimInvoiceMatchClient;
import com.xforceplus.phoenix.match.client.model.match.BillItemVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceItemVO;
import com.xforceplus.phoenix.match.common.enums.ItemMatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.StatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.NewMatchMapper;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillInvoiceDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillItemDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemExample;
import com.xforceplus.phoenix.match.service.BillInvoiceGroupService;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.pim.client.model.MsBatchUpdateInvoiceItemMatchStatusRequest;
import com.xforceplus.phoenix.pim.client.model.MsUpdateInvoiceMatchStatusRequest;
import com.xforceplus.phoenix.tools.util.NullableUtil;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionDetailBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BillInvoiceGroupServiceImpl
implements BillInvoiceGroupService {
    private static final Logger log = LoggerFactory.getLogger(BillInvoiceGroupServiceImpl.class);
    @Autowired
    MtcSalesbillInvoiceDao mtcSalesbillInvoiceDao;
    @Autowired
    MtcSalesbillItemDao mtcSalesbillItemDao;
    @Autowired
    PimInvoiceMatchClient pimInvoiceMatchClient;
    @Autowired
    DependService dependService;
    @Autowired
    NewMatchMapper newMatchMapper;
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;
    @Value(value="${isCheckItemUnit:1}")
    private Integer isCheckItemUnit;

    public Set<BillInvoiceGroupBean> getBillInvoiceGroup(Set<Long> invoiceIds, Set<Long> billIds, boolean isInOneGroup) {
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(invoiceIds) && CollectionUtils.isEmpty(billIds)) {
            return null;
        }
        HashSet<BillInvoiceGroupBean> resultSet = new HashSet<BillInvoiceGroupBean>();
        if (isInOneGroup) {
            BillInvoiceGroupBean bean = this.getGroupBeanByInvoiceAndBill(invoiceIds, billIds);
            resultSet.add(bean);
        } else {
            if (CollectionUtils.isNotEmpty(invoiceIds)) {
                for (Long invoiceId : invoiceIds) {
                    Set invoiceGroupResult = this.getBillInvoiceGroup(new HashSet<Long>(Arrays.asList(invoiceId)), null, true);
                    resultSet.addAll(invoiceGroupResult);
                }
            }
            if (CollectionUtils.isNotEmpty(billIds)) {
                for (Long billId : billIds) {
                    Set billGroupResult = this.getBillInvoiceGroup(null, new HashSet<Long>(Arrays.asList(billId)), true);
                    resultSet.addAll(billGroupResult);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("getBillInvoiceGroup\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
        return resultSet;
    }

    public void validateGroupItemByBillAndInvoice(BillInvoiceGroupBean bean, List<MatchConditionDetailBean.AuthConditionInfo> matchDetailConditions, boolean ableConfirm) {
        String key;
        long startTime = System.currentTimeMillis();
        HashMap billItemStatusMap = Maps.newHashMap();
        HashMap invoiceItemStatusMap = Maps.newHashMap();
        Set billIds = bean.getBillIds();
        Set invoiceIds = bean.getInvoiceIds();
        List billItems = this.getBillItems(billIds);
        Map<String, List<BillItemVO>> billItemMap = billItems.stream().collect(Collectors.groupingBy(BillItemVO::getItemName));
        List invoiceItems = this.getInvoiceItems(invoiceIds);
        Map<String, List<InvoiceItemVO>> invoiceItemMap = invoiceItems.stream().collect(Collectors.groupingBy(InvoiceItemVO::getCargoName));
        if (CollectionUtils.isEmpty((Collection)billItems) || CollectionUtils.isEmpty((Collection)invoiceItems)) {
            log.warn("\u5355\u636e\u53d1\u7968\u6ca1\u6709\u660e\u7ec6\u6570\u636egroupBean{}", (Object)JSONObject.toJSONString((Object)bean));
        }
        if (CollectionUtils.isEmpty((Collection)bean.getRelatedIds())) {
            if (CollectionUtils.isNotEmpty(billItemMap.keySet())) {
                List billItemIds = billItemMap.values().stream().flatMap(e -> e.stream().map(item -> item.getSalesbillItemId())).collect(Collectors.toList());
                billItemStatusMap.put(ItemMatchStatusEnum.DEFAULT.value(), billItemIds);
            }
            if (CollectionUtils.isNotEmpty(invoiceItemMap.keySet())) {
                List invoiceItemIds = invoiceItemMap.values().stream().flatMap(e -> e.stream().map(item -> item.getId())).collect(Collectors.toList());
                invoiceItemStatusMap.put(ItemMatchStatusEnum.DEFAULT.value(), invoiceItemIds);
            }
            this.updateItemMatchStatus((Map)billItemStatusMap, (Map)invoiceItemStatusMap);
            return;
        }
        HashMap<String, List<BillItemVO>> correctBillItemMap = new HashMap<String, List<BillItemVO>>();
        HashMap<String, List<BillItemVO>> correctInvoiceItemMap = new HashMap<String, List<BillItemVO>>();
        HashMap<String, List<BillItemVO>> errorBillItemMap = new HashMap<String, List<BillItemVO>>();
        HashMap<String, List<BillItemVO>> errorInvoiceItemMap = new HashMap<String, List<BillItemVO>>();
        HashSet<String> errorBillItemNameSet = new HashSet<String>(billItemMap.keySet());
        HashSet<String> errorInvoiceItemNameSet = new HashSet<String>(invoiceItemMap.keySet());
        errorBillItemNameSet.removeAll(invoiceItemMap.keySet());
        errorInvoiceItemNameSet.removeAll(billItemMap.keySet());
        for (Map.Entry<String, List<BillItemVO>> entry : billItemMap.entrySet()) {
            key = entry.getKey();
            if (errorBillItemNameSet.contains(key)) {
                errorBillItemMap.put(key, entry.getValue());
                continue;
            }
            correctBillItemMap.put(key, entry.getValue());
        }
        for (Map.Entry<String, List<BillItemVO>> entry : invoiceItemMap.entrySet()) {
            key = entry.getKey();
            if (errorInvoiceItemNameSet.contains(key)) {
                errorInvoiceItemMap.put(key, entry.getValue());
                continue;
            }
            correctInvoiceItemMap.put(key, entry.getValue());
        }
        this.generateErrorItemMap(correctInvoiceItemMap, correctBillItemMap, (Map)billItemStatusMap, (Map)invoiceItemStatusMap, matchDetailConditions);
        List errorNameInvoiceItems = errorInvoiceItemMap.values().stream().flatMap(e -> e.stream().map(item -> item.getId())).collect(Collectors.toList());
        List list = errorBillItemMap.values().stream().flatMap(e -> e.stream().map(item -> item.getSalesbillItemId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            billItemStatusMap.put(ItemMatchStatusEnum.MATCH_NAME_ERROR.value(), list);
        }
        if (CollectionUtils.isNotEmpty(errorNameInvoiceItems)) {
            invoiceItemStatusMap.put(ItemMatchStatusEnum.MATCH_NAME_ERROR.value(), errorNameInvoiceItems);
        }
        List errorBillItemIds = billItemStatusMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List correctBillItemIds = billItems.stream().filter(e -> !errorBillItemIds.contains(e.getSalesbillItemId())).map(BillItemVO::getSalesbillItemId).collect(Collectors.toList());
        List errorInvoiceItemIds = invoiceItemStatusMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List correctInvoiceItemIds = invoiceItems.stream().filter(e -> !errorInvoiceItemIds.contains(e.getId())).map(InvoiceItemVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(correctBillItemIds)) {
            billItemStatusMap.put(ItemMatchStatusEnum.DEFAULT.value(), correctBillItemIds);
        }
        if (CollectionUtils.isNotEmpty(correctInvoiceItemIds)) {
            invoiceItemStatusMap.put(ItemMatchStatusEnum.DEFAULT.value(), correctInvoiceItemIds);
        }
        this.updateMatchStatus((Map)billItemStatusMap, (Map)invoiceItemStatusMap, billItems, invoiceItems, billIds, bean, ableConfirm);
        long endTime = System.currentTimeMillis();
        log.info("validateGroupItemByBean\u8017\u65f6\uff1a{}\uff0c\u5bf9\u8c61\uff1a{}", (Object)(endTime - startTime), (Object)JSONObject.toJSONString((Object)bean));
    }

    private void updateMatchStatus(Map<String, List<Long>> billItemStatusMap, Map<String, List<Long>> invoiceItemStatusMap, List<BillItemVO> billItems, List<InvoiceItemVO> invoiceItems, Set<Long> billIds, BillInvoiceGroupBean bean, boolean ableConfirm) {
        CompletableFuture<Void> updateBillTask;
        long startTime = System.currentTimeMillis();
        HashMap errorbillItemStatusMap = new HashMap();
        billItemStatusMap.forEach((k, v) -> {
            if (!k.equals(ItemMatchStatusEnum.DEFAULT.value())) {
                errorbillItemStatusMap.put(k, v);
            }
        });
        HashMap errorInvoiceItemStatusMap = new HashMap();
        invoiceItemStatusMap.forEach((k, v) -> {
            if (!k.equals(ItemMatchStatusEnum.DEFAULT.value())) {
                errorInvoiceItemStatusMap.put(k, v);
            }
        });
        List billErrorItemId = errorbillItemStatusMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List errorBillItemList = billItems.stream().filter(item -> billErrorItemId.contains(item.getSalesbillItemId())).collect(Collectors.toList());
        List errorBillIds = errorBillItemList.stream().map(BillItemVO::getSalesbillId).distinct().collect(Collectors.toList());
        List invoiceErrorItemId = errorInvoiceItemStatusMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List errorInvoiceItemList = invoiceItems.stream().filter(item -> invoiceErrorItemId.contains(item.getId())).collect(Collectors.toList());
        List errorInvoiceIds = errorInvoiceItemList.stream().map(InvoiceItemVO::getInvoiceId).distinct().collect(Collectors.toList());
        ArrayList correctInvoiceIds = new ArrayList();
        correctInvoiceIds.addAll(new ArrayList(bean.getInvoiceIds()));
        correctInvoiceIds.removeAll(errorInvoiceIds);
        ArrayList correctBillIds = new ArrayList();
        correctBillIds.addAll(new ArrayList(bean.getBillIds()));
        correctBillIds.removeAll(errorBillIds);
        CompletableFuture<Void> updateItemTask = CompletableFuture.runAsync(() -> this.updateItemMatchStatus(billItemStatusMap, invoiceItemStatusMap));
        if (CollectionUtils.isNotEmpty(errorInvoiceIds)) {
            log.info("updateMatchStatus\u66f4\u65b0\u5355\u636e\u72b6\u60011errorInvoiceIds:{},billIds:{}", errorInvoiceIds, billIds);
            updateBillTask = CompletableFuture.runAsync(() -> this.updateBillMatchStatusByItem(new ArrayList(billIds)));
        } else {
            log.info("updateMatchStatus\u66f4\u65b0\u5355\u636e\u72b6\u60012errorBillIds:{}", errorBillIds);
            updateBillTask = CompletableFuture.runAsync(() -> this.updateBillMatchStatusByItem(errorBillIds));
        }
        CompletableFuture<Void> updateErrorInvoiceTask = CompletableFuture.runAsync(() -> {});
        if (CollectionUtils.isNotEmpty(errorInvoiceIds)) {
            log.info("updateMatchStatus\u66f4\u65b0\u53d1\u7968\u72b6\u60011errorInvoiceIds:{}", errorInvoiceIds);
            updateErrorInvoiceTask = CompletableFuture.runAsync(() -> this.updateInvoiceMatchStatusByItem(errorInvoiceIds, MatchStatusEnum.MATCH_CONFIRM.getValue(), null));
        }
        CompletableFuture<Void> updateCorrectInvoiceTask = CompletableFuture.runAsync(() -> {});
        if (CollectionUtils.isNotEmpty(correctInvoiceIds) && !ableConfirm) {
            log.info("updateMatchStatus\u66f4\u65b0\u53d1\u7968\u72b6\u60012correctInvoiceIds:{}", correctInvoiceIds);
            updateCorrectInvoiceTask = CompletableFuture.runAsync(() -> this.updateInvoiceMatchStatusByItem(correctInvoiceIds, MatchStatusEnum.MATCH_END.getValue(), Arrays.asList(MatchStatusEnum.MATCH_CONFIRM.getValue())));
        }
        CompletableFuture<Void> updateRelatedToNeedConfirmTask = CompletableFuture.runAsync(() -> {});
        if (CollectionUtils.isNotEmpty(errorBillIds) || CollectionUtils.isNotEmpty(errorInvoiceIds)) {
            log.info("updateMatchStatus\u66f4\u65b0\u5173\u7cfb\u72b6\u60011errorBillIds:{},errorInvoiceIds:{}", errorBillIds, errorInvoiceIds);
            updateRelatedToNeedConfirmTask = CompletableFuture.runAsync(() -> this.updateRelatedStatusToNeedConfirm(errorBillIds, errorInvoiceIds));
        }
        CompletableFuture<Void> updateRelatedToCorrectTask = CompletableFuture.runAsync(() -> {});
        if (CollectionUtils.isNotEmpty(correctBillIds) && CollectionUtils.isNotEmpty(correctInvoiceIds) && !ableConfirm) {
            log.info("updateMatchStatus\u66f4\u65b0\u5173\u7cfb\u72b6\u60012correctBillIds:{},correctInvoiceIds:{}", correctBillIds, correctInvoiceIds);
            updateRelatedToCorrectTask = CompletableFuture.runAsync(() -> this.updateRelatedStatusToCorrect(correctBillIds, correctInvoiceIds));
        }
        CompletableFuture<Void> allOf = CompletableFuture.allOf(updateItemTask, updateBillTask, updateErrorInvoiceTask, updateCorrectInvoiceTask, updateRelatedToNeedConfirmTask, updateRelatedToCorrectTask);
        try {
            allOf.get();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        log.info("updateMatchStatus\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
    }

    public void validateGroupItemByBillAndInvoice(Set<Long> invoiceIds, Set<Long> billIds, boolean isInOneGroup, List<MatchConditionDetailBean.AuthConditionInfo> matchDetailConditions, boolean ableConfirm) {
        Set billInvoiceGroupSet = this.getBillInvoiceGroup(invoiceIds, billIds, isInOneGroup);
        if (CollectionUtils.isNotEmpty((Collection)billInvoiceGroupSet)) {
            for (BillInvoiceGroupBean groupBean : billInvoiceGroupSet) {
                this.validateGroupItemByBillAndInvoice(groupBean, matchDetailConditions, ableConfirm);
            }
        }
    }

    private void updateRelatedStatusToCorrect(List<Long> correctBillIds, List<Long> correctInvoiceIds) {
        MtcSalesbillInvoiceEntity updateEntity = new MtcSalesbillInvoiceEntity();
        updateEntity.setStatus(Integer.valueOf(0));
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        example.or().andSalesbillIdIn(correctBillIds).andInvoiceIdIn(correctInvoiceIds).andStatusEqualTo(Integer.valueOf(2));
        this.mtcSalesbillInvoiceDao.updateByExampleSelective(updateEntity, example);
    }

    private void updateRelatedStatusToNeedConfirm(List<Long> errorBillIds, List<Long> errorInvoiceIds) {
        MtcSalesbillInvoiceEntity updateEntity = new MtcSalesbillInvoiceEntity();
        updateEntity.setStatus(Integer.valueOf(2));
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        if (CollectionUtils.isNotEmpty(errorBillIds)) {
            example.or().andSalesbillIdIn(errorBillIds).andStatusEqualTo(Integer.valueOf(0));
        }
        if (CollectionUtils.isNotEmpty(errorInvoiceIds)) {
            example.or().andInvoiceIdIn(errorInvoiceIds).andStatusEqualTo(Integer.valueOf(0));
        }
        this.mtcSalesbillInvoiceDao.updateByExampleSelective(updateEntity, example);
    }

    private void updateInvoiceMatchStatusByItem(List<Long> errorInvoiceIds, Integer matchStatus, List<Integer> originalMatchStatus) {
        long startTime = System.currentTimeMillis();
        MsUpdateInvoiceMatchStatusRequest request = new MsUpdateInvoiceMatchStatusRequest();
        request.setInvoiceIds(errorInvoiceIds);
        if (CollectionUtils.isNotEmpty(originalMatchStatus)) {
            request.setOriginalMatchStatus(originalMatchStatus);
        }
        request.setToMatchStatus(matchStatus);
        this.pimInvoiceMatchClient.updateMatchStatusByInvoiceIds(request);
        long endTime = System.currentTimeMillis();
        log.info("updateInvoiceMatchStatusByItem\u8017\u65f6{}", (Object)(endTime - startTime));
    }

    private void updateBillMatchStatusByItem(List<Long> errorBillIds) {
        if (CollectionUtils.isNotEmpty(errorBillIds)) {
            MtcSalesbillExample updateBillExample = new MtcSalesbillExample();
            MtcSalesbillExample.Criteria criteria = updateBillExample.createCriteria().andSalesbillIdIn(errorBillIds);
            MtcSalesbillEntity updateBill = new MtcSalesbillEntity();
            updateBill.setMatchStatus(MatchStatusEnum.MATCH_CONFIRM.getValue().toString());
            this.mtcSalesbillDao.updateByExampleSelective(updateBill, updateBillExample);
        }
    }

    private List<BillItemVO> getBillItems(Set<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return new ArrayList<BillItemVO>();
        }
        MtcSalesbillItemExample billExample = new MtcSalesbillItemExample();
        List<Integer> normalStatus = Arrays.asList(StatusEnum.OK.code(), StatusEnum.MADE.code(), StatusEnum.OPEN_INVOICE.code());
        billExample.createCriteria().andSalesbillIdIn(new ArrayList<Long>(billIds)).andStatusIn(normalStatus);
        List billItems = this.mtcSalesbillItemDao.selectByExample(billExample);
        return billItems.parallelStream().map(e -> this.newMatchMapper.toBillItemVO(e)).collect(Collectors.toList());
    }

    private Map<String, List<InvoiceItemVO>> getInvoiceItemMap(Set<Long> invoiceIds) {
        if (CollectionUtils.isEmpty(invoiceIds)) {
            return new HashMap<String, List<InvoiceItemVO>>();
        }
        long startTime = System.currentTimeMillis();
        List totalInvoiceDetails = Collections.synchronizedList(new ArrayList());
        invoiceIds.parallelStream().forEach(e -> {
            List pimDetails = this.dependService.getMsPimInvoiceDetailRowById(e);
            if (CollectionUtils.isNotEmpty((Collection)pimDetails)) {
                totalInvoiceDetails.addAll(pimDetails);
            }
        });
        Map<String, List<InvoiceItemVO>> itemMap = totalInvoiceDetails.parallelStream().map(e -> this.newMatchMapper.toInvoiceItemVO(e)).collect(Collectors.groupingBy(InvoiceItemVO::getCargoName));
        long endTime = System.currentTimeMillis();
        log.info("getInvoiceItemMap\u8017\u65f6\uff1a{},\u660e\u7ec6\u6570\u91cf {}", (Object)(endTime - startTime), (Object)totalInvoiceDetails.size());
        return itemMap;
    }

    private List<InvoiceItemVO> getInvoiceItems(Set<Long> invoiceIds) {
        if (CollectionUtils.isEmpty(invoiceIds)) {
            return new ArrayList<InvoiceItemVO>();
        }
        long startTime = System.currentTimeMillis();
        List totalInvoiceDetails = Collections.synchronizedList(new ArrayList());
        invoiceIds.parallelStream().forEach(e -> {
            List pimDetails = this.dependService.getMsPimInvoiceDetailRowById(e);
            if (CollectionUtils.isNotEmpty((Collection)pimDetails)) {
                totalInvoiceDetails.addAll(pimDetails);
            }
        });
        List<InvoiceItemVO> itemList = totalInvoiceDetails.parallelStream().map(e -> this.newMatchMapper.toInvoiceItemVO(e)).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        log.info("getInvoiceItems\u8017\u65f6\uff1a{},\u660e\u7ec6\u6570\u91cf {}", (Object)(endTime - startTime), (Object)totalInvoiceDetails.size());
        return itemList;
    }

    private BillInvoiceGroupBean getGroupBeanByInvoiceAndBill(Set<Long> invoiceIds, Set<Long> billIds) {
        List salesbillInvoices;
        BillInvoiceGroupBean bean = new BillInvoiceGroupBean();
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        if (CollectionUtils.isNotEmpty(invoiceIds)) {
            MtcSalesbillInvoiceExample.Criteria criteriaInvoice = example.or();
            criteriaInvoice.andInvoiceIdIn(new ArrayList<Long>(invoiceIds)).andStatusNotEqualTo(Integer.valueOf(1));
        }
        if (CollectionUtils.isNotEmpty(billIds)) {
            MtcSalesbillInvoiceExample.Criteria criteriaBill = example.or();
            criteriaBill.andSalesbillIdIn(new ArrayList<Long>(billIds)).andStatusNotEqualTo(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(salesbillInvoices = this.mtcSalesbillInvoiceDao.selectByExample(example)))) {
            bean.setBillIds(billIds);
            bean.setInvoiceIds(invoiceIds);
            return bean;
        }
        Set allInvoiceIds = salesbillInvoices.stream().map(e -> e.getInvoiceId()).collect(Collectors.toSet());
        Set allbillIds = salesbillInvoices.stream().map(e -> e.getSalesbillId()).collect(Collectors.toSet());
        Set allRelatedIds = salesbillInvoices.stream().map(e -> e.getId()).collect(Collectors.toSet());
        HashSet nextInvoiceIds = new HashSet();
        nextInvoiceIds.addAll(allInvoiceIds);
        if (CollectionUtils.isNotEmpty(invoiceIds)) {
            nextInvoiceIds.removeAll(invoiceIds);
        }
        HashSet nextBillIds = new HashSet();
        nextBillIds.addAll(allbillIds);
        if (CollectionUtils.isNotEmpty(billIds)) {
            nextBillIds.removeAll(billIds);
        }
        bean.setBillIds(allbillIds);
        bean.setInvoiceIds(allInvoiceIds);
        bean.setRelatedIds(allRelatedIds);
        this.getNextBillAndInvoice(nextInvoiceIds, nextBillIds, bean);
        return bean;
    }

    private BillInvoiceGroupBean getNextBillAndInvoice(Set<Long> invoiceIds, Set<Long> billIds, BillInvoiceGroupBean bean) {
        List salesbillInvoices;
        if (CollectionUtils.isEmpty(invoiceIds) && CollectionUtils.isEmpty(billIds)) {
            return bean;
        }
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        if (CollectionUtils.isNotEmpty(invoiceIds)) {
            MtcSalesbillInvoiceExample.Criteria criteriaInvoice = example.or();
            criteriaInvoice.andInvoiceIdIn(new ArrayList<Long>(invoiceIds)).andIdNotIn(new ArrayList(bean.getRelatedIds())).andStatusNotEqualTo(Integer.valueOf(1));
        }
        if (CollectionUtils.isNotEmpty(billIds)) {
            MtcSalesbillInvoiceExample.Criteria criteriaBill = example.or();
            criteriaBill.andSalesbillIdIn(new ArrayList<Long>(billIds)).andIdNotIn(new ArrayList(bean.getRelatedIds())).andStatusNotEqualTo(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(salesbillInvoices = this.mtcSalesbillInvoiceDao.selectByExample(example)))) {
            return bean;
        }
        Set currentInvoiceIds = salesbillInvoices.stream().map(e -> e.getInvoiceId()).collect(Collectors.toSet());
        Set currentBillIds = salesbillInvoices.stream().map(e -> e.getSalesbillId()).collect(Collectors.toSet());
        Set currentRelatedIds = salesbillInvoices.stream().map(e -> e.getId()).collect(Collectors.toSet());
        HashSet nextInvoiceIds = new HashSet();
        nextInvoiceIds.addAll(currentInvoiceIds);
        nextInvoiceIds.removeAll(bean.getInvoiceIds());
        HashSet nextBillIds = new HashSet();
        nextBillIds.addAll(currentBillIds);
        nextBillIds.removeAll(bean.getBillIds());
        bean.getBillIds().addAll(currentBillIds);
        bean.getInvoiceIds().addAll(currentInvoiceIds);
        bean.getRelatedIds().addAll(currentRelatedIds);
        return this.getNextBillAndInvoice(nextInvoiceIds, nextBillIds, bean);
    }

    private void generateErrorItemMap(Map<String, List<InvoiceItemVO>> correctInvoiceItemMap, Map<String, List<BillItemVO>> correctBillItemMap, Map<String, List<Long>> errorBillItemMap, Map<String, List<Long>> errorInvoiceItemMap, List<MatchConditionDetailBean.AuthConditionInfo> matchDetailConditions) {
        MatchConditionDetailBean.AuthConditionInfo quantityCheck = matchDetailConditions.stream().filter(e -> e.getCondition().equals((Object)MatchConditionDetailBean.ConditionEnum.C02)).findFirst().orElse(null);
        MatchConditionDetailBean.AuthConditionInfo amountCheck = matchDetailConditions.stream().filter(e -> e.getCondition().equals((Object)MatchConditionDetailBean.ConditionEnum.C03)).findFirst().orElse(null);
        MatchConditionDetailBean.AuthConditionInfo taxCheck = matchDetailConditions.stream().filter(e -> e.getCondition().equals((Object)MatchConditionDetailBean.ConditionEnum.C04)).findFirst().orElse(null);
        Set<Map.Entry<String, List<BillItemVO>>> billEntrys = correctBillItemMap.entrySet();
        for (Map.Entry<String, List<BillItemVO>> billEntry : billEntrys) {
            BigDecimal invoiceTaxAmount;
            BigDecimal tolerance;
            BigDecimal invoiceAmountWithoutTax;
            String itemName = billEntry.getKey();
            List<BillItemVO> billItems = billEntry.getValue();
            BigDecimal billQuantity = billItems.stream().map(BillItemVO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal billAmountWithoutTax = billItems.stream().map(e -> e.getAmountWithoutTax().subtract(e.getInnerDiscountWithoutTax()).subtract(e.getOutterDiscountWithoutTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal billTaxAmount = billItems.stream().map(e -> e.getTaxAmount().subtract(e.getInnerDiscountTax()).subtract(e.getOutterDiscountTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            Set billQuantityUnitSet = billItems.stream().map(e -> e.getQuantityUnit().trim()).collect(Collectors.toSet());
            List<InvoiceItemVO> invoiceItems = correctInvoiceItemMap.get(itemName);
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(invoiceItems)) continue;
            ArrayList errorStatusList = Lists.newArrayList();
            if (quantityCheck != null) {
                Set invoiceQuantityUnitSet = invoiceItems.stream().map(e -> e.getQuantityUnit().trim()).collect(Collectors.toSet());
                if (!(this.isCheckItemUnit != 1 || billQuantityUnitSet.size() <= 1 && billQuantityUnitSet.equals(invoiceQuantityUnitSet))) {
                    errorStatusList.add(ItemMatchStatusEnum.MATCH_QUANTITY_ERROR.value());
                } else {
                    BigDecimal tolerance2;
                    BigDecimal invoiceQuantity = invoiceItems.stream().map(e -> NullableUtil.toBigDecimalValue((Object)e.getQuantity(), (BigDecimal)BigDecimal.ZERO)).reduce(BigDecimal.ZERO, (e1, e2) -> e1.add((BigDecimal)e2));
                    if (!this.validateTolerance(billQuantity, invoiceQuantity, tolerance2 = BigDecimal.valueOf(quantityCheck.getValue())).booleanValue()) {
                        errorStatusList.add(ItemMatchStatusEnum.MATCH_QUANTITY_ERROR.value());
                    }
                }
            }
            if (amountCheck != null && !this.validateTolerance(billAmountWithoutTax, invoiceAmountWithoutTax = invoiceItems.stream().map(e -> new BigDecimal(e.getAmountWithoutTax())).reduce(BigDecimal.ZERO, BigDecimal::add), tolerance = BigDecimal.valueOf(amountCheck.getValue())).booleanValue()) {
                errorStatusList.add(ItemMatchStatusEnum.MATCH_AMOUNT_ERROR.value());
            }
            if (taxCheck != null && !this.validateTolerance(billTaxAmount, invoiceTaxAmount = invoiceItems.stream().map(e -> new BigDecimal(e.getTaxAmount())).reduce(BigDecimal.ZERO, BigDecimal::add), tolerance = BigDecimal.valueOf(taxCheck.getValue())).booleanValue()) {
                errorStatusList.add(ItemMatchStatusEnum.MATCH_TAX_ERROR.value());
            }
            List billItemIds = billItems.stream().map(BillItemVO::getSalesbillItemId).collect(Collectors.toList());
            List invoiceItemIds = invoiceItems.stream().map(InvoiceItemVO::getId).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty((Collection)errorStatusList)) continue;
            String errorStatusKey = String.join((CharSequence)",", errorStatusList);
            this.mergeErrorItemMap(errorInvoiceItemMap, invoiceItemIds, errorStatusKey);
            this.mergeErrorItemMap(errorBillItemMap, billItemIds, errorStatusKey);
        }
    }

    private void mergeErrorItemMap(Map<String, List<Long>> errorItemMap, List<Long> itemIds, String errorStatusKey) {
        errorItemMap.merge(errorStatusKey, itemIds, (oldV, newv) -> {
            if (null == oldV) {
                return newv;
            }
            oldV.addAll(newv);
            return oldV;
        });
    }

    public void updateItemMatchStatus(Map<String, List<Long>> billItemStatusMap, Map<String, List<Long>> invoiceItemStatusMap) {
        long startTime = System.currentTimeMillis();
        log.info("updateItemMatchStatus\u6267\u884c\u5f00\u59cb");
        if (CollectionUtils.isNotEmpty(billItemStatusMap.keySet())) {
            for (Map.Entry<String, List<Long>> entry2 : billItemStatusMap.entrySet()) {
                String itemMatchStatus = entry2.getKey();
                List<Long> billItemIds = entry2.getValue();
                MtcSalesbillItemEntity billItem = new MtcSalesbillItemEntity();
                billItem.setItemMatchStatus(itemMatchStatus);
                MtcSalesbillItemExample billItemExample = new MtcSalesbillItemExample();
                billItemExample.createCriteria().andSalesbillItemIdIn(billItemIds);
                this.mtcSalesbillItemDao.updateByExampleSelective(billItem, billItemExample);
            }
        }
        if (CollectionUtils.isNotEmpty(invoiceItemStatusMap.keySet())) {
            invoiceItemStatusMap.entrySet().parallelStream().forEach(entry -> {
                String itemMatchStatus = (String)entry.getKey();
                List invoiceItemIds = (List)entry.getValue();
                MsBatchUpdateInvoiceItemMatchStatusRequest updateRequest = new MsBatchUpdateInvoiceItemMatchStatusRequest();
                updateRequest.setInvoiceItemIds(invoiceItemIds);
                updateRequest.setItemMatchStatus(itemMatchStatus);
                try {
                    this.pimInvoiceMatchClient.batchUpdateInvoiceItemMatchStatus(updateRequest);
                }
                catch (Exception e) {
                    log.error("\u914d\u5355\u66f4\u65b0\u53d1\u7968\u660e\u7ec6\u62a5\u9519 {}", (Throwable)e);
                    throw e;
                }
            });
        }
        long endTime = System.currentTimeMillis();
        log.info("updateItemMatchStatus\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
    }

    private Boolean validateTolerance(BigDecimal amount1, BigDecimal amount2, BigDecimal tolerance) {
        return amount1.subtract(amount2).abs().compareTo(tolerance) <= 0;
    }
}

